<?php

return [
    'report_cache_path'     => 'uploads/report_temp/report_cache',
    'report_cron_send_path' => 'uploads/report_temp/report_cron_sent',
    'table_columns' => [
        'article' => [
            'article_journal' => [
                'label' => 'Journal name',
                'column' => 'jnl_journal_name',
                'tables' => [
                    [
                        'name' => 'rvw_article_types',
                        'join' => 'RIGHT',
                        'on' => ['rvw_articles.art_artp_id', '=', 'rvw_article_types.artp_id']
                    ],
                    [
                        'name' => 'rvw_journals',
                        'join' => 'RIGHT',
                        'on' => ['rvw_article_types.artp_jnl_id', '=', 'rvw_journals.jnl_id']
                    ]
                ],
                'condition' => ['type' => 'string']
            ],
            'article_journal_code' => [
                'label' => 'Journal code',
                'column' => 'jnl_journal_code',
                'tables' => [
                    [
                        'name' => 'rvw_article_types',
                        'join' => 'RIGHT',
                        'on' => ['rvw_articles.art_artp_id', '=', 'rvw_article_types.artp_id']
                    ],
                    [
                        'name' => 'rvw_journals',
                        'join' => 'RIGHT',
                        'on' => ['rvw_article_types.artp_jnl_id', '=', 'rvw_journals.jnl_id']
                    ]
                ],
                'condition' => ['type' => 'string']
            ],
            'article_type' => [
                'label' => 'Article type (as submitted)',
                'column' => 'rvw_article_types.artp_article_type',
                'tables' => [
                    [
                        'name' => 'rvw_article_types',
                        'join' => 'RIGHT',
                        'on' => ['rvw_articles.art_artp_id', '=', 'rvw_article_types.artp_id']
                    ],
                ],
                'condition' => ['type' => 'string']
            ],
            'published_article_type' => [
                'label' => 'Article type (as published)',
                'column' => 'pub_article_type.artp_article_type',
                'tables' => [
                    [
                        'name' => 'rvw_article_types as pub_article_type',
                        'join' => '',
                        'on' => ['rvw_articles.art_published_article_type', '=', 'pub_article_type.artp_id']
                    ]
                ],
                'condition' => ['type' => 'string']
            ],
            'artp_abbr_article_type' => [
                'label' => 'Article type code(e.g. LET)(as submitted)',
                'column' => 'rvw_article_types.artp_abbr_article_type',
                'tables' => [
                    [
                        'name' => 'rvw_article_types',
                        'join' => 'RIGHT',
                        'on' => ['rvw_articles.art_artp_id', '=', 'rvw_article_types.artp_id']
                    ]
                ],
                'condition' => ['type' => 'string']
            ],
            'published_article_type_code' => [
                'label' => 'Article type code (as published)',
                'column' => 'published_article_type.artp_abbr_article_type',
                'tables' => [
                    [
                        'name' => 'rvw_article_types as published_article_type',
                        'join' => 'RIGHT',
                        'on' => ['rvw_articles.art_published_article_type', '=', 'published_article_type.artp_id']
                    ]
                ],
                'condition' => ['type' => 'string']
            ],
            'art_code' => [
                'label' => 'Article ID',
                'column' => 'rvw_articles.art_code',
                'tables' => [],
                'condition' => ['type' => 'string']
            ],
            'art_pre_all_ids' => [
                'label' => 'Original ID of paper (if resubmitted)',
                'column' => 'art_cp.art_code',
                'tables' => [
                    [
                        'name' => 'rvw_articles as art_cp',
                        'join' => '',
                        'on' => ['art_cp.art_id', '=', 'IF( rvw_articles.art_pre_all_ids is null,rvw_articles.art_id,SUBSTRING_INDEX(rvw_articles.art_pre_all_ids, ",", 1))']
                    ]
                ],
                'condition' => ['type' => 'string']
            ],
            'art_flags' => [
                'label' => 'Article Flags',
                'column' => 'rvw_flags.flag_name',
                'tables' => [
                    [
                        'name' => 'rvw_article_flag',
                        'join' => 'LEFT',
                        'on' => ['rvw_articles.art_id', '=', 'rvw_article_flag.aflg_art_id']
                    ],
                    [
                        'name' => 'rvw_flags',
                        'join' => 'LEFT',
                        'on' => ['rvw_article_flag.aflg_flag_id', '=', 'rvw_flags.flag_id']
                    ]
                ],
                'condition' => ['type' => 'string']
            ],
            'art_title' => [
                'label' => 'Article title',
                'column' => 'rvw_articles.art_title',//'IF(LENGTH(`rvw_articles`.`art_title`) > 50, CONCAT(LEFT(`rvw_articles`.`art_title`, 47), "..."), `rvw_articles`.`art_title`)'
                'tables' => [],
                'condition' => ['type' => 'string']
            ],
            'art_abstract' => [
                'label' => 'Article abstract',
                'column' => 'rvw_articles.art_abstract',//'IF(LENGTH(`rvw_articles`.`art_abstract`) > 50, CONCAT(LEFT(`rvw_articles`.`art_abstract`, 47), "..."), `rvw_articles`.`art_abstract`)'
                'tables' => [],
                'condition' => ['type' => 'string']
            ],
            'art_biorxiv' => [
                'label' => 'bioRxiv',
                'column' => 'rvw_articles.art_biorxiv',
                'tables' => [],
                'condition' => ['type' => 'string']
            ],
            'art_submitted_by' => [
                'label' => 'Submitting author',
                'column' => 'concat( rvw_users.`usr_first_name`,IF(rvw_users.`usr_middle_name` IS NULL or rvw_users.`usr_middle_name`="", " ", CONCAT(" ",rvw_users.usr_middle_name," ")),rvw_users.`usr_last_name`)',
                'tables' => [
                    [
                        'name' => 'rvw_article_authors',
                        'join' => '',
                        'on' => ['rvw_articles.art_id', '=', 'rvw_article_authors.auth_art_id']
                    ],
                    [
                        'name' => 'rvw_users',
                        'join' => '',
                        'on' => ['rvw_article_authors.auth_usr_id', '=', 'rvw_users.usr_id']
                    ]
                ],
                'condition' => ['type' => 'string']
            ],
            'art_original_submission_date' => [
                'label' => 'Date of Original submission (if resubmitted)',
                'column' => 'arts_date.art_submission_date',
                'tables' => [
                    [
                        'name' => 'rvw_articles as arts_date',
                        'join' => '',
                        'on' => ['arts_date.art_id', '=', "IF( rvw_articles.art_pre_all_ids is null,rvw_articles.art_id,SUBSTRING_INDEX(rvw_articles.art_pre_all_ids, ',', 1))"]
                    ]
                ],
                'condition' => ['type' => 'date', 'col_fn' => "date(col_name)", 'sel_fn' => "DATE_FORMAT(col_name,'DATE_FORMAT_KEY')"]
            ],
            'days_since_submission' => [
                'label' => 'Days since submission',
                'column' => 'CASE WHEN  rvw_articles.art_submission_date!=0 AND rvw_articles.art_submission_date IS NOT NULL THEN  '
				    . 'datediff(now(),rvw_articles.art_submission_date) ELSE NULL  END',
                'tables' => [],
                'condition' => ['type' => 'string']

            ],
            'art_submission_date' => [
                'label' => 'Date of submission',
                'column' => 'rvw_articles.art_submission_date',
                'tables' => [],
                'condition' => ['type' => 'date', 'col_fn' => "date(col_name)", 'sel_fn' => "DATE_FORMAT(col_name,'DATE_FORMAT_KEY')"]
            ],
            'art_decision_name' => [
                'label' => 'Decision (e.g. Accept)',
                'column' => 'rvw_journal_workflows.jwf_stage_name',
                'tables' => [
                    [
                        'name' => "(SELECT MAX(aflw_id) max_aflw_id, min(aflw_id) min_aflw_id, aflw_art_id FROM rvw_article_flow JOIN rvw_journal_workflows ON rvw_article_flow.aflw_jwf_id = rvw_journal_workflows.jwf_id WHERE rvw_journal_workflows.jwf_stage_type IN( 'accept', 'reject', 'decision_revision', 'resubmission' ) AND aflw_returned_date IS NOT NULL GROUP BY aflw_art_id) art_flow_table",
                        'join' => 'LEFT',
                        'on' => ['rvw_articles.art_id', '=', 'art_flow_table.aflw_art_id']
                    ],
                    [
                        'name' => 'rvw_article_flow',
                        'join' => '',
                        'on' => ['rvw_article_flow.aflw_id', '=', 'art_flow_table.max_aflw_id']
                    ],
                    [
                        'name' => 'rvw_journal_workflows',
                        'join' => '',
                        'on' => ['rvw_journal_workflows.jwf_id', '=', 'rvw_article_flow.aflw_jwf_id']
                    ]
                ],
                'condition' => ['type' => 'string']
            ],
            'art_decision_date' => [
                'label' => 'Date of first decision',
                'column' => 'rvw_article_min_flow.aflw_returned_date',
                'tables' => [
                    [
                        'name' => "(SELECT MAX(aflw_id) max_aflw_id, min(aflw_id) min_aflw_id, aflw_art_id FROM rvw_article_flow JOIN rvw_journal_workflows ON rvw_article_flow.aflw_jwf_id = rvw_journal_workflows.jwf_id WHERE rvw_journal_workflows.jwf_stage_type IN( 'accept', 'reject', 'decision_revision', 'resubmission' ) AND aflw_returned_date IS NOT NULL GROUP BY aflw_art_id) art_flow_table",
                        'join' => 'LEFT',
                        'on' => ['rvw_articles.art_id', '=', 'art_flow_table.aflw_art_id']
                    ],
                    [
                        'name' => 'rvw_article_flow as rvw_article_min_flow',
                        'join' => '',
                        'on' => ['rvw_article_min_flow.aflw_id', '=', 'art_flow_table.min_aflw_id']
                    ],
                ],
                'condition' => ['type' => 'date', 'col_fn' => "date(col_name)", 'sel_fn' => "DATE_FORMAT(col_name,'DATE_FORMAT_KEY')"]
            ],
            'art_final_decision_date' => [
                'label' => 'Date of final decision',
                'column' => 'rvw_article_max_flow.aflw_returned_date',
                'tables' => [
                    [
                        'name' => "(SELECT MAX(aflw_id) max_aflw_id, min(aflw_id) min_aflw_id, aflw_art_id FROM rvw_article_flow JOIN rvw_journal_workflows ON rvw_article_flow.aflw_jwf_id = rvw_journal_workflows.jwf_id WHERE rvw_journal_workflows.jwf_stage_type IN( 'accept', 'reject', 'decision_revision', 'resubmission' ) AND aflw_returned_date IS NOT NULL GROUP BY aflw_art_id) art_flow_table",
                        'join' => 'LEFT',
                        'on' => ['rvw_articles.art_id', '=', 'art_flow_table.aflw_art_id']
                    ],
                    [
                        'name' => 'rvw_article_flow as rvw_article_max_flow',
                        'join' => '',
                        'on' => ['rvw_article_max_flow.aflw_id', '=', 'art_flow_table.max_aflw_id']
                    ],
                ],
                'condition' => ['type' => 'date', 'col_fn' => "date(col_name)", 'sel_fn' => "DATE_FORMAT(col_name,'DATE_FORMAT_KEY')"]
            ],
            'jwf_all_status_names'=>[
                'label' => 'Tasks (e.g. admin check)',
                'column' => '`journal_workflows_task`.`jwf_stage_name`',
                'tables' => [
                    [
                        'name' => '(SELECT aflw_id,aflw_art_id,aflw_jwf_id,(CASE WHEN aflw_status=\'d\' THEN aflw_returned_date ELSE NULL END) as aflw_rejected_date,aflw_returned_date,aflw_accepted_date FROM `rvw_article_flow`) article_flow_table',
                        'join' => 'LEFT',
                        'on' => ['rvw_articles.art_id', '=',  'article_flow_table.aflw_art_id']
                    ],
                    [
                        'name' => 'rvw_journal_workflows as journal_workflows_task',
                        'join' => 'LEFT',
                        'on' => ['article_flow_table.aflw_jwf_id', '=', 'journal_workflows_task.jwf_id']
                    ]
                ],
                'condition' => ['type' => 'string']
            ],
            'jwf_all_status_accepted_date'=>[
                'label' => 'Task accepted date',
                'column' => '`article_flow_table`.`aflw_accepted_date`',
                'tables' => [
                    [
                        'name' => '(SELECT aflw_id,aflw_art_id,aflw_jwf_id,(CASE WHEN aflw_status=\'d\' THEN aflw_returned_date ELSE NULL END) as aflw_rejected_date,aflw_returned_date,aflw_accepted_date FROM `rvw_article_flow`) article_flow_table',
                        'join' => 'LEFT',
                        'on' => ['rvw_articles.art_id', '=',  'article_flow_table.aflw_art_id']
                    ]
                ],
                'condition' => ['type' => 'date', 'col_fn' => "date(col_name)", 'sel_fn' => "DATE_FORMAT(col_name,'DATE_FORMAT_KEY')"]
            ],
            'jwf_all_status_completed_date'=>[
                'label' => 'Task completed date',
                'column' => '`article_flow_table`.`aflw_returned_date`',
                'tables' => [
                    [
                        'name' => '(SELECT aflw_id,aflw_art_id,aflw_jwf_id,(CASE WHEN aflw_status=\'d\' THEN aflw_returned_date ELSE NULL END) as aflw_rejected_date,aflw_returned_date,aflw_accepted_date FROM `rvw_article_flow`) article_flow_table',
                        'join' => 'LEFT',
                        'on' => ['rvw_articles.art_id', '=',  'article_flow_table.aflw_art_id']
                    ]
                ],
                'condition' => ['type' => 'date', 'col_fn' => "date(col_name)", 'sel_fn' => "DATE_FORMAT(col_name,'DATE_FORMAT_KEY')"]
            ],
            'jwf_all_status_rejected_date'=>[
                'label' => 'Task rejected date',
                'column' => '`article_flow_table`.`aflw_rejected_date`',
                'tables' => [
                    [
                        'name' => '(SELECT aflw_id,aflw_art_id,aflw_jwf_id,(CASE WHEN aflw_status=\'d\' THEN aflw_returned_date ELSE NULL END) as aflw_rejected_date,aflw_returned_date,aflw_accepted_date FROM `rvw_article_flow`) article_flow_table',
                        'join' => 'LEFT',
                        'on' => ['rvw_articles.art_id', '=', 'article_flow_table.aflw_art_id']
                    ]
                ],
                'condition' => ['type' => 'date', 'col_fn' => "date(col_name)", 'sel_fn' => "DATE_FORMAT(col_name,'DATE_FORMAT_KEY')"]
            ],

        ]
    ],
    'condition_params' => [
        'type' => [
            'string' => [
                'is' => ["=", "?"],
                'contains' => ["like", "%?%"],
                'starts_with' => ["like", "?%"],
                'ends_with' => ["like", "%?"],
                'not_contains' => ["not like", "%?%"],
                'not_start_with' => ["not like", "?%"],
                'not_end_with' => ["not like", "%?"]
            ],
            'number' => [
                'equals' => [" = ", "?"],
                'not_equal' => [" != ", "?"],
                'greater_than' => [" > ", "?"],
                'greater_than_equal' => [" >= ", "?"],
                'less than' => [" < ", "?"],
                'less_than_equal' => [" <= ", "?"],
            ],
            'date' => [
                'is' => ["=", "?"],
                'is_not' => ["!=", "?"],
                'after' => [">", "?"],
                'include_and_after' => [">=", "?"],
                'before' => ["<", "?"],
                'include_and_before' => ["<=", "?"],
            ]
        ]
    ],
    'filters' => [],
    'field_type_functions' => [
        'string' => [
            'group_by' => [
                'label'     => 'List as is',
                // 'function'  => 'GROUP BY REPLACE'
            ],
            'group_concat' => [
                'label'     => 'Collect in same row if possible',
                // 'function'  => 'GROUP_CONCAT(DISTINCT REPLACE )'
            ],
            'count' => [
                'label'     => 'Count number of occurrences',
                // 'function'  => 'count(distinct REPLACE)'
            ],
            'ratio' => [
                'label'     => 'Ratio',
                // 'function'  => 'ROUND((count(distinct REPLACE)/(count(distinct REPLACE) + BASE_RATIO_FUNCTION )) * 100 ,2)',
                // 'function_ratio_base' => 'count(distinct REPLACE)',
            ]
        ]
    ],
    'show_column_total_type' => [
        'unique_row_value' => [
			'label' => 'Total number of unique values',
			// 'condition_value' => 'unique_row_value',
			// 'display_value' => 'Total number of unique COLUMN_NAME',
			// 'function' => 'count(DISTINCT REPLACE) AS LABEL_NAME',
			// 'action_on' => 'both', //both number and sting
        ],
        'total_row_count' => [
			'label' => 'Total number of values',
			// 'condition_value' => 'total_row_count',
			// 'display_value' => 'Total number of COLUMN_NAME',
			// 'function' => 'count(REPLACE) AS LABEL_NAME',
			// 'action_on' => 'both', //both number and sting
        ],
        'sum_rows' => [
			'label' => 'Sum of values',
			// 'condition_value' => 'sum_rows',
			// 'display_value' => 'Sum of COLUMN_NAME',
			// 'function' => 'sum(REPLACE) AS LABEL_NAME',
			// 'action_on' => 'number',
		],
    ],
    'delimeters' => [
        'comma' => [
            'label' => 'Comma (,)',
            // 'condition_value' => 'comma',
            'value' => ', ',
        ],
        'semicolon' => [
            'label' => 'Semicolon (;)',
            // 'condition_value' => 'semicolon',
            'value' => '; ',
        ],
        'new_line' => [
            'label' => 'New line',
            // 'condition_value' => 'new_line',
            'value' => '<br>',
        ]
    ]

];
