<?php

/*$config['credit']['status'] =[
	'eq' =>'Equal',
	'sp' =>'Supporting',
	'ld' =>'Lead',
];*/
return [
'review_flow' => [
		'author_submission' =>[
			'label' => 'Author Submission',
			'assignment_tabs' => true,
			'internal_statges' =>[
				'author_submission' => 'Author Submission'
			],
			'roles' =>[
				'author'],
			'child_stages' =>[
				'staff_check',
				'pre_assessment',
				'review',
				'authors_declaration'],
			'email_templates' =>[
			],
			'possible_email_tmpl_actions' =>[
				'completed' => 'On complete',
				'accepted_not_completed' => 'Reminder to complete',
				'rescind_destination' => 'On rescind(destination stage)',
				'manual_reminder'=>'Manual reminder',
				'assigned' => 'On assignment/invitation',
        		'uninvite_user' => 'Uninvite user',
				],
			'multiple_child' => false, // flag to set the stage allow multiple childs or not
			'more_reviewers' => false,
			'stage_for' => 'review',
			'prevent_edit' => false,
			'enable_ithenticate' => FALSE,
			'enable_research_integrity' => FALSE
		],
		'transit' =>[
			'label' => 'Transit',
			'assignment_tabs' => true,
			'internal_statges' =>[
				'transit' => 'Transit'
			],
			'roles' =>[
				'author'],
			'static_forms' =>[
				'transfer_suggestions'
			],
			'generic_form' => -1, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.' Changed 0 to -1 . Transit stage don't need custom forms
			'child_stages' =>[],
			'email_templates' =>[
			],
			'possible_email_tmpl_actions' =>[
				'completed' => 'On complete',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
				],
			'multiple_child' => false, // flag to set the stage allow multiple childs or not
			'enable_casrai_credits_confirm' => false,
			'enable_orcid_confirm' => false,
			'more_reviewers' => false,
			'stage_for' => 'review',
			'prevent_edit' => true,
			'enable_ithenticate' => FALSE,
			'enable_research_integrity' => FALSE
		],
		'authors_declaration' =>[
			'label' => 'Authors Declaration',
			'assignment_tabs' => true,
			'internal_statges' =>[
				'authors_declaration' => 'Authors Declaration'
			],
			'roles' =>[
				'author'],
			'child_stages' =>[
				'staff_check',
				'pre_assessment'],
			'email_templates' =>[
//				'article_tags',
//				'author_tags'
			],
			'possible_email_tmpl_actions' =>[
				'assigned' => 'On stage initialization',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage]',
				'rescind_destination' => ')',
				'reset' => 'On Reset',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
				],
			'disable_criteria' =>[],
			'multiple_child' => false, // flag to set the stage allow multiple childs or not
			//If disable criteria is empty this stage can be disabled without any check.
			'permission' =>[
				'rescind',
				'reset',
			],
			'multiple_stages' => TRUE,
			'enable_casrai_credits_confirm' => false,
			'enable_orcid_confirm' => false,
			'more_reviewers' => false,
			'stage_for' => 'review',
			'prevent_edit' => true,
			'enable_ithenticate' => FALSE,
			'enable_research_integrity' => FALSE
		],
		'staff_check' =>[
                        'export_to_gigadb'=>TRUE,
			'label' => 'Staff Check',
			'assignment_tabs' => true,
			'internal_statges' =>[
				'ready_for_staff_check' => 'Ready for %stage_name%',
				'staff_check_in_progress' => '%stage_name% in Progress'
			],
			'roles' =>[
				'staff',
				'associate_editor',
				'editor_in_chief'
			],
			'child_stages' =>[
				'review',
				'pre_assessment',
				'post_assessment',
				'revision',
				'reject']
			,
			'email_templates' =>[
//					'article_tags',
//					'author_tags',
			],
			'possible_email_tmpl_actions' =>[
				'initialization' => 'On stage initialization',
				'assigned' => 'On assignment/invitation',
				'unassign_user' => 'Unassign user',
				//'uninvite_user' => 'Uninvite user',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On Reset',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
				],
			'multiple_child' => true, 
			'disable_criteria' =>[
				'before' =>[],
				'after' =>[
					'pre_assessment',
					'post_assessment'
				],
				'and' => TRUE
			],
			'permission' =>[
				'rescind',
				'reset',
				'transfer'
			],
			'enable_ithenticate' => TRUE,
//			'comments_to_author' => true
			'enable_casrai_credits_confirm' => false,
			'enable_orcid_confirm' => false,
			'more_reviewers' => false,
			'stage_for' => 'review',
			'prevent_edit' => false,
			'enable_research_integrity' => TRUE
		],
		'pre_assessment' =>[
			'label' => 'Pre-review Assessment',
			'internal_statges' =>[
				'ready_for_pre_assessment' => 'Ready for %stage_name%',
				'pre_assessment_in_progress' => '%stage_name% in Progress'
			],
			'roles' =>[
				'associate_editor',
				'editor_in_chief','staff'],
			'child_stages' =>[
				'pre_assessment',
				'review',
				'post_assessment',
				'revision',
				'reject',
				'accept'],
			'email_templates' =>[
//					'article_tags',
//					'author_tags',
//				'transfer_article_tags',
			],
			'possible_email_tmpl_actions' =>[
				'initialization' => 'On stage initialization',
				'assigned' => 'On assignment/invitation',
				'accepted' => 'On accept',
				'declined' => 'On decline',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On reset',
				'unassign_user' => 'Unassign user',
				'uninvite_user' => 'Uninvite user',
				'assigned_not_accepted' => 'Reminder to accept',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
				],
			'multiple_child' => true, 
			'default_assignment_type' => 'self_service',
			'assignment_options' =>[
				'self_service',
				//'invitation',
				'manual'],
			'disable_criteria' =>[
				'before' =>[
					'staff_check',
					'pre_assessment'
				],
				'after' =>[],
				'and' => TRUE
			],
			'permission' =>[
				'rescind',
				'reset',
				'transfer'
			],
			'assignment_tabs' => true,
			'enable_ithenticate' => FALSE,
			'enable_casrai_credits_confirm' => false,
			'enable_orcid_confirm' => false,
			'more_reviewers' => false,
			'stage_for' => 'review',
			'prevent_edit' => false,
			'enable_research_integrity' => FALSE
//			'comments_to_author' => true
		],
		'revision' =>[
			'label' => 'Author correction',
			'internal_statges' =>[
				'revision' => 'Revision',
			],
			'roles' =>[
				'author'],
			'child_stages' =>[
				'staff_check',
				'pre_assessment',
				'post_assessment',
			],
			'email_templates' =>[
//					'article_tags',
//					'author_tags',
			],
			'possible_email_tmpl_actions' =>[
				'assigned' => 'On stage initialization',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On reset',
				'accepted_not_completed' => 'Reminder to complete',
				'confirm_casrai' => 'Confirm Contributorship',
				'confirm_orcid' => 'Connect ORCID',
				'manual_reminder'=>'Manual reminder',
				],
			'arrow_begin_with' => 'Top',
			'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
			'multiple_child' => false, // flag to set the stage allow multiple childs or not
			'disable_criteria' =>[],
			'permission' =>[
				'rescind',
				'reset',
			],
			'assignment_tabs' => true,
			'enable_casrai_credits_confirm' => false,
			'enable_orcid_confirm' => false,
			'more_reviewers' => false,
			'stage_for' => 'review',
			'prevent_edit' => true,
		],
		'review' =>[
			'label' => 'Peer review Process',
			'internal_statges' =>[
				'ready_for_review' => 'Ready for %stage_name%',
				'review_in_progress' => '%stage_name% in Progress'
			],
			'roles' =>[
				'reviewer'], //assigned only reviewer role for review stage
			'child_stages' =>[
				'review',
				'post_assessment',
//				'ae_recommendation',
			],
			'email_templates' =>[
//					'article_tags',
			//	'author_tags',
//				'review_tags',
			],
			'possible_email_tmpl_actions' =>[
				'initialization' => 'On stage initialization',
				'assigned' => 'On assignment/invitation',
				'accepted' => 'On accept',
				'declined' => 'On decline',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'unassign_user' => 'Unassign user',
				'uninvite_user' => 'Uninvite user',
				'reset' => 'On Reset',
				'assigned_not_accepted' => 'Reminder to accept',
				'accepted_not_completed' => 'Reminder to complete',
				'pnd_reviewer_shortlist' => 'Reminder to shortlist reviewer', //pending
				'pnd_reviewer_invite' => 'Reminder to invite reviewer',
				'manual_reminder'=>'Manual reminder',
				'review_resubmit' => 'Review resubmit'
				],//pending
			'invite' => true,
			//default assignment is should be either invitation or manual because self_service not available for review
			'default_assignment_type' => 'invitation',
			'assignment_options' =>[
				'invitation',
				'manual'],
//			'static_forms' =>[
//				'review_summary'
//			],
			'participate_discussion_roles' =>[
				'staff',
				'associate_editor',
				'editor_in_chief'
			],
			'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
			'multiple_child' => false, // flag to set the stage allow multiple childs or not
			'disable_criteria' =>[],
			'permission' =>[
				'rescind',
				'reset',
			],
			'assignment_tabs' => FALSE,
			'enable_casrai_credits_confirm' => false,
			'enable_orcid_confirm' => false,
			'more_reviewers' => false,
			'stage_for' => 'review',
			'prevent_edit' => false,
		],
		'post_assessment' =>[
			'label' => 'Post-review assessment',
			'internal_statges' =>[
				'ready_for_post_assessment' => 'Ready for Post-review Assessment',
				'post_assessment_in_progress' => 'Post-review Assessment in Progress'
			],
			'roles' =>[
				'associate_editor',
				'editor_in_chief'],
			'child_stages' =>[
				'post_assessment',
				'revision',
				'accept',
				'reject',
				'decision_revision',
				'resubmission'],
			'email_templates' =>[
//					'article_tags',
			//	'author_tags',
//				'review_tags',
			],
			'possible_email_tmpl_actions' =>[
				'initialization' => 'On stage initialization',
				'assigned' => 'On assignment/invitation',
				'accepted' => 'On accept',
				'declined' => 'On decline',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On reset',
				'repeat_stage' => 'On repeat', //repeat stage due to reopen review
				'unassign_user' => 'Unassign user',
				'uninvite_user' => 'Uninvite user',
				'assigned_not_accepted' => 'Reminder to accept',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
				],
			'multiple_child' => true, 
			'default_assignment_type' => 'self_service',
			'assignment_options' =>[
				'self_service',
				//'invitation',
				'manual'],
			'disable_criteria' =>[
				'before' =>[
					'post_assessment'
				],
				'after' =>[
					'post_assessment'
				],
				'and' => FALSE
			],
			'permission' =>[
				'rescind',
				'reset',
				'transfer'
			],
			'assignment_tabs' => false,
			'enable_casrai_credits_confirm' => false,
			'enable_orcid_confirm' => false,
			'more_reviewers' => true,
			'stage_for' => 'review',
			'prevent_edit' => false,
//			'comments_to_author' => true
		],
		'accept' =>[
			'label' => 'Decision Accept',
			'internal_statges' =>[
				'accept_for_publish' => 'Accepted for Publishing'
			],
			'roles' =>[
				'staff',
				'associate_editor',
				'editor_in_chief'],
			'child_stages' =>[
				'copyright',
				'production',
				'qulity_check',
				'publish'
			],
			'email_templates' =>[
//					'article_tags',
//					'author_tags',
//				'review_tags'
			],
			'generic_form' => 0,
			'possible_email_tmpl_actions' =>[
				'initialization' => 'On stage initialization',
				'assigned' => 'On assignment/invitation',
				'unassign_user' => 'Unassign user',
				//'uninvite_user' => 'Uninvite user',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On reset',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
				],
			'multiple_child' => true, 
			'permission' =>[
				'rescind',
				'reset',
				'notifications'
			],
			'assignment_tabs' => false,
			'enable_casrai_credits_confirm' => false,
			'enable_orcid_confirm' => false,
			'more_reviewers' => false,
			'stage_for' => 'review',
			'prevent_edit' => false,
		],
		'reject' =>[
			'label' => 'Decision Reject',
			'assignment_tabs' => false,
			'internal_statges' =>[
				'reject' => 'Article rejected'
			],
			'roles' =>[
				'staff',
				'associate_editor',
				'editor_in_chief'],
			'child_stages' =>[],
			'email_templates' =>[
//					'article_tags',
			//	'author_tags',
//				'review_tags'
			],
			'possible_email_tmpl_actions' =>[
				'initialization' => 'On stage initialization',
				'assigned' => 'On assignment/invitation',
				'unassign_user' => 'Unassign user',
				//'uninvite_user' => 'Uninvite user',
				'declined' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On reset',
				'manual_reminder'=>'Manual reminder',
				],
			'multiple_child' => true, 
			'permission' =>[
				'rescind',
				'reset',
				'notifications',
				'transfer'
			],
			'generic_form' => 0,
			'enable_casrai_credits_confirm' => false,
			'enable_orcid_confirm' => false,
			'more_reviewers' => false,
			'stage_for' => 'review',
			'prevent_edit' => false,
		],
		'decision_revision' =>[
			'label' => 'Decision Revision',
			'internal_statges' =>[
				'decision_revision' => 'Confirm Revision'
			],
			'roles' =>[
				'staff',
				'associate_editor',
				'editor_in_chief'],
			'child_stages' =>[
				'resubmission',
				'revision'],
			'email_templates' =>[
//				'review_tags'
			],
			'possible_email_tmpl_actions' =>[
				'initialization' => 'On stage initialization',
				'assigned' => 'On assignment/invitation',
				'unassign_user' => 'Unassign user',
				//'uninvite_user' => 'Uninvite user',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On reset',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
				],
			'arrow_begin_with' => 'Top',
			'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
			'multiple_child' => true, // flag to set the stage allow multiple childs or not
			'permission' =>[
				'rescind',
				'reset',
				'notifications'
			],
			'assignment_tabs' => false,
			'enable_casrai_credits_confirm' => false,
			'enable_orcid_confirm' => false,
			'more_reviewers' => false,
			'stage_for' => 'review',
			'prevent_edit' => false,
		],
		'decision_resubmit' =>[
			'label' => 'Decision Re-submit',
			'internal_statges' =>[
				'decision_resubmit' => 'Confirm Resubmission'
			],
			'roles' =>[
				'staff'],
			'child_stages' =>[
				'resubmission'],
			'email_templates' =>[
			],
			'possible_email_tmpl_actions' =>[
				'initialization' => 'On stage initialization',
				'assigned' => 'On assignment/invitation',
				'unassign_user' => 'Unassign user',
				//'uninvite_user' => 'Uninvite user',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On reset',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
				],
			'default_assignment_type' => 'auto',
			'assignment_options' =>[
				'auto'],
			'generic_form' => false,
			'multiple_child' => false, // flag to set the stage allow multiple childs or not
			'permission' =>[
				'rescind',
				'reset',
				'notifications'
			],
			'assignment_tabs' => true,
			'enable_casrai_credits_confirm' => false,
			'enable_orcid_confirm' => false,
			'more_reviewers' => false,
			'stage_for' => 'review',
			'prevent_edit' => false,
		],
		'resubmission' =>[
			'label' => 'Revision',
			'assignment_tabs' => true,
			'internal_statges' =>[
				'resubmission_requested' => 'Revision Requested',
				'payment_request_sent' => 'Revision in Progress',
			],
			'roles' =>[
				'author'],
			'child_stages' =>[
				'staff_check',
				'pre_assessment',
				'post_assessment'],
			'email_templates' =>[
//					'article_tags',
//					'author_tags',
			],
			'possible_email_tmpl_actions' =>[
				'initialization' => 'On stage initialization', // bcoz start resubmission work as checkout
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On reset',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
				],
			'arrow_begin_with' => 'Top',
			'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
			'multiple_child' => false, // flag to set the stage allow multiple childs or not
			'permission' =>[
				'rescind',
				'reset',
			],
			'enable_casrai_credits_confirm' => false,
			'enable_orcid_confirm' => false,
			'more_reviewers' => false,
			'stage_for' => 'review',
			'prevent_edit' => true,
		],
		'copyright' =>[
			'label' => 'Copyright',
			'assignment_tabs' => true,
			'internal_statges' =>[
				'copyright' => 'Copyright',
			],
			'roles' =>[
				'author'],
			'child_stages' =>[
				'license_check'
			],
			'email_templates' =>[
//					'article_tags',
//					'author_tags',
				'copyright_tags',
			],
			'possible_email_tmpl_actions' =>[
				'assigned' => 'On stage initialization',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On reset',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
				],
			'static_forms' =>[
				'copyright'
			],
			'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
			'multiple_child' => false, // flag to set the stage allow multiple childs or not
			'permission' =>[
				'rescind',
				'reset',
			],
			'enable_casrai_credits_confirm' => false,
			'enable_orcid_confirm' => false,
			'more_reviewers' => false,
			'stage_for' => 'review',
			'prevent_edit' => true,
		],
		'license_check' =>[
			'label' => 'License Check',
			'internal_statges' =>[
				'license_check' => 'License Check',
			],
			'roles' =>[
				'staff'],
			'child_stages' =>[
				'payment',
				'production'
			],
			'email_templates' =>[
//					'article_tags',
//					'author_tags',
				'copyright_tags',
			],
			'possible_email_tmpl_actions' =>[
				'initialization' => 'On stage initialization',
				'assigned' => 'On assignment/invitation',
				'unassign_user' => 'Unassign user',
				//'uninvite_user' => 'Uninvite user',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On reset',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
				],
			'generic_form' => 1, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
			'multiple_child' => true, // flag to set the stage allow multiple childs or not
			'permission' =>[
				'rescind',
				'reset',
			],
			'assignment_tabs' => true,
			'enable_casrai_credits_confirm' => false,
			'enable_orcid_confirm' => false,
			'more_reviewers' => false,
			'stage_for' => 'review',
			'prevent_edit' => false,
		],
		'payment' =>[
			'label' => 'Payment',
			'assignment_tabs' => true,
			'internal_statges' =>[
				'payment' => 'Payment',
			],
			'roles' =>[
				'system'],
			'child_stages' =>[
				'production'
			],
			'email_templates' =>[
//					'article_tags',
//					'author_tags',
			],
			'possible_email_tmpl_actions' =>[
				'initialization' => 'On stage initialization',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On reset',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
				],
			'static_forms' =>[
				'payment'
			],
			'generic_form' => -1, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
			'multiple_child' => false, // flag to set the stage allow multiple childs or not
			'permission' =>[
				'rescind',
				'reset',
			],
			'stage_skip_condition' =>[
				'select' => 'count(*] as cnt',
				'model' => 'Payment_order',
				'field' => 'cnt',
				'condition' => ' == 0',
				'article_id' => 'pmt_ord_art_id'
			],
			'enable_casrai_credits_confirm' => false,
			'enable_orcid_confirm' => false,
			'more_reviewers' => false,
			'stage_for' => 'review',
			'prevent_edit' => false,
		],
		'production' =>[
			'label' => 'Production',
			'assignment_tabs' => false,
			'internal_statges' =>[
				'ready_for_production' => 'Ready for Production',
				'production_in_progress' => 'Article Production in Progress',
			],
			'roles' =>[
				// 'editor_in_chief',
				// 'associate_editor',
				'staff',
				// 'production_manager'
			],
			'child_stages' =>[],
			'email_templates' =>[
//					'article_tags',
			//	'author_tags',
			],
			'possible_email_tmpl_actions' =>[
				'initialization' => 'On stage initialization',
				'assigned' => 'On assignment/invitation',
				'unassign_user' => 'Unassign user',
				//'uninvite_user' => 'Uninvite user',
				'export' => 'On export',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On reset',
				'manual_reminder'=>'Manual reminder',
				],
			'multiple_child' => true, 
			'permission' =>[
				'rescind',
				'reset',
			],
			'enable_casrai_credits_confirm' => false,
			'enable_orcid_confirm' => false,
			'more_reviewers' => false,
			'stage_for' => 'review',
			'prevent_edit' => false,
		],
		'qulity_check' => [
			'label' => 'Quality checking',
			'assignment_tabs' => FALSE,
			'internal_statges' => [
				'ready_for_qulity_checking' => 'Ready for %stage_name%',
				'qulity_checking_in_progress' => '%stage_name% in Progress'
			],
			'roles' => [
				'production_manager',
				'tsp',
				'type_setter'
			],
			'child_stages' => [
				'editorial_amendment',
				'graphic_processing',
				'preprocessing',
				'publish'
			]
			,
			'email_templates' => [
//					'article_tags',
//					'author_tags',
			],
			'possible_email_tmpl_actions' => [
				'initialization' => 'On stage initialization',
				'unassign_user' => 'Unassign user',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On Reset',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
			],
			'multiple_child' => true, 
			'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
			'permission' => [
				//'rescind',
				'reset',
			],
			'download' => [
				'production_package' => FALSE,
				'previous_files' => FALSE,
			],
			'upload_type' => 'optional', //there is upload required
			'upload' => [
				'zip',
				'pdf',
				'jpg',
				'jpeg',
                                'tif',
                                'tiff',
                                'eps',
				'png',
				'doc',
				'docx',
                                'xls',
                                'xlsx',
                                'ppt',
                                'pptx'
			],
			'enable_ithenticate' => FALSE,
//			'comments_to_author' => true
			'enable_casrai_credits_confirm' => FALSE,
			'enable_orcid_confirm' => FALSE,
			'more_reviewers' => FALSE,
			'milestone_stage' => FALSE,
			'stage_for' => 'manageproduction',
			'prevent_edit' => false,
			'enable_research_integrity' => FALSE
],
		'editorial_amendment' => [
			'label' => 'Editorial amendment',
			'assignment_tabs' => FALSE,
			'internal_statges' => [
				'ready_for_editorial_amendment' => 'Ready for %stage_name%',
				'editorial_amendment_in_progress' => '%stage_name% in Progress'
			],
			'roles' =>[
				'editor_in_chief',
                'staff'
			],
			'child_stages' => [
				'qulity_check',
				'pro_revision'
				]
			,
			'email_templates' => [
					'article_tags',
					'author_tags',
			],
			'possible_email_tmpl_actions' => [
				'initialization' => 'On stage initialization',
				'unassign_user' => 'Unassign user',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On Reset',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
			],
			'multiple_child' => true, 
			'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
			'permission' => [
				'rescind',
				'reset',
			],
			'download' => [
				'production_package' => FALSE,
				'previous_files' => FALSE,
			],
			'upload_type' => 'required', //there is upload required
			'upload' => [
				'zip',
				'pdf',
				'jpeg',
				'jpg',
				'png',
				'doc',
				'docx',
			],
			'enable_ithenticate' => FALSE,
//			'comments_to_author' => true
			'enable_casrai_credits_confirm' => FALSE,
			'enable_orcid_confirm' => FALSE,
			'more_reviewers' => FALSE,
			'milestone_stage' => FALSE,
			'stage_for' => 'manageproduction',
			'show_rview_history' => TRUE,
			'prevent_edit' => false,
			'enable_research_integrity' => FALSE
],
		'pro_revision' => [
			'label' => 'Author correction(Production)',
			'internal_statges' => [
				'pro_revision' => 'Revision',
			],
			'roles' => [
				'author'],
			'child_stages' => [
				'editorial_amendment'
			],
			'email_templates' => [
//					'article_tags',
//					'author_tags',
			],
			'possible_email_tmpl_actions' => [
				'assigned' => 'On stage initialization',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On reset',
				'accepted_not_completed' => 'Reminder to complete',
				//'confirm_casrai' => 'Confirm Contributorship',
				'confirm_orcid' => 'Connect ORCID',
				'manual_reminder'=>'Manual reminder',
				],
			'arrow_begin_with' => 'Top',
			'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
			'multiple_child' => false, // flag to set the stage allow multiple childs or not
			'disable_criteria' => [],
			'permission' => [
				'rescind',
				'reset',
			],
			'download' => [
				'production_package' => FALSE,
				'previous_files' => FALSE,
			],
			'upload_type' => 'required', //there is upload required
			'upload' => [
				'zip',
				'pdf',
				'jpeg',
				'jpg',
				'png',
				'doc',
				'docx',
				'tif',
				'tiff',
				'odt',
				'tex',
				'eps',
				'ppt',
				'xls',
				'xlsx',
				'bst',
				'cls',
				'bib',
				'pptx',
				'gif',
				'mov',
			],
			'assignment_tabs' => false,
			'enable_casrai_credits_confirm' => false,
			'enable_orcid_confirm' => false,
			'more_reviewers' => false,
			'stage_for' => 'manageproduction',
			'show_rview_history' => FALSE,
			'prevent_edit' => true,
		],
		'editorial_process' => [
			'label' => 'Editorial process',
			'assignment_tabs' => FALSE,
			'internal_statges' => [
				'ready_for_editorial_process' => 'Ready for %stage_name%',
				'editorial_process_in_progress' => '%stage_name% in Progress'
			],
			'roles' => [
				'type_setter',
				'production_manager',
				'tsp',
				'editor_in_chief',
                'staff'
			],
			'child_stages' => [
				'preprocessing',
				'copy_editing',
				'type_setting',
				'graphic_processing',
				'postprocessing',
				'aop_publish'
			],
			'email_templates' => [
//					'article_tags',
//					'author_tags',
			],
			'possible_email_tmpl_actions' => [
				'initialization' => 'On stage initialization',
				'assigned' => 'On assignment/invitation',
				'unassign_user' => 'Unassign user',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On Reset',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
				],
			'multiple_child' => true, 
			'default_assignment_type' => 'self_service',
			'assignment_options' => [
				'self_service',
				//'invitation',
				'manual'],
			'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
			'permission' => [
				'rescind',
				'reset',
			],
			'download' => [
				'production_package' => FALSE,
				'previous_files' => FALSE,
			],
			'upload_type' => 'required', //there is upload required
			'upload' => [
				'zip',
				'pdf',
				'doc',
				'docx',
				'jpg',
				'jpeg',
                                'tif',
                                'tiff',
				'png',
			],
			'enable_ithenticate' => FALSE,
//			'comments_to_author' => true
			'enable_casrai_credits_confirm' => FALSE,
			'enable_orcid_confirm' => FALSE,
			'more_reviewers' => FALSE,
			'milestone_stage' => FALSE,
			'stage_for' => 'manageproduction',
			'prevent_edit' => false,
			'enable_research_integrity' => FALSE
		],
		'preprocessing' => [
			'label' => 'Preprocessing',
			'assignment_tabs' => FALSE,
			'internal_statges' => [
				'ready_for_preprocessing' => 'Ready for %stage_name%',
				'preprocessing_in_progress' => '%stage_name% in Progress'
			],
			'roles' => [
				'production_manager',
				'type_setter',
			],
			'child_stages' => [
				'aop_publish',
				'preprocessing',
				'editorial_process',
				'copy_editing',
				'type_setting',
				]
			,
			'email_templates' => [
//					'article_tags',
//					'author_tags',
			],
			'possible_email_tmpl_actions' => [
				'initialization' => 'On stage initialization',
				'assigned' => 'On assignment/invitation',
				'unassign_user' => 'Unassign user',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On Reset',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
				],
			'multiple_child' => true, 
			'default_assignment_type' => 'self_service',
			'assignment_options' => [
				'self_service',
				//'invitation',
				'manual'],
			'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
			'permission' => [
				'rescind',
				'reset',
			],
			'download' => [
				'production_package' => FALSE,
				'previous_files' => FALSE,
			],
			'upload_type' => 'optional', //there is upload optional
			'upload' => [
				'zip',
				'pdf',
				'jpeg',
				'jpg',
				'png',
				'doc',
				'docx',
                                'indd'
			],
			'list_allstage_files' => TRUE,
			'file_annotate' => TRUE,
			'enable_ithenticate' => FALSE,
//			'comments_to_author' => true
			'enable_casrai_credits_confirm' => FALSE,
			'enable_orcid_confirm' => FALSE,
			'more_reviewers' => FALSE,
			'milestone_stage' => FALSE,
			'stage_for' => 'manageproduction',
			'prevent_edit' => false,
			'enable_research_integrity' => FALSE
		],
		'aop_publish' => [
			'label' => 'AoP Publish',
			'assignment_tabs' => false,
			'internal_statges' => [
				'ready_for_aop_publish' => 'Ready for %stage_name%',
				'aop_publish_in_progress' => '%stage_name% in Progress'
			],
			'roles' => [
				'tsp',
				'production_manager',
				],
//			'static_forms' => [
//				'transfer_suggestions'
//			],
			'generic_form' => -1, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.' Changed 0 to -1 . Transit stage don't need custom forms
			'child_stages' => [],
			'email_templates' => [],
			'download' => [
				'production_package' => FALSE,
				'previous_files' => FALSE,
			],
			'list_allstage_files' => TRUE,
			'file_annotate' => TRUE,
			'possible_email_tmpl_actions' => [
				'completed' => 'On complete',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
				],
			'multiple_child' => false, // flag to set the stage allow multiple childs or not
			'permission' => [
				'rescind',
				'reset',
			],
			'enable_casrai_credits_confirm' => false,
			'enable_orcid_confirm' => false,
			'more_reviewers' => false,
			'milestone_stage' => TRUE,
			'stage_for' => 'manageproduction',
			'prevent_edit' => false,
		],
		'graphic_processing' => [
			'label' => 'Graphic processing',
			'assignment_tabs' => FALSE,
			'internal_statges' => [
				'ready_for_graphic_processing' => 'Ready for %stage_name%',
				'graphic_processing_in_progress' => '%stage_name% in Progress'
			],
			'roles' => [
				'production_manager',
				'tsp',
                'type_setter'
			],
			'child_stages' => [
				'editorial_process',
			],
			'email_templates' => [
//					'article_tags',
//					'author_tags',
			],
			'possible_email_tmpl_actions' => [
				'initialization' => 'On stage initialization',
				'assigned' => 'On assignment/invitation',
				'unassign_user' => 'Unassign user',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On Reset',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
				],
			'multiple_child' => true, 
			'default_assignment_type' => 'self_service',
			'assignment_options' => [
				'self_service',
				//'invitation',
				'manual'],
			'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
			'permission' => [
				'rescind',
				'reset',
			],
			'download' => [
				'production_package' => FALSE,
				'previous_files' => FALSE,
			],
			'upload_type' => 'required', //there is upload required
			'upload' => [
				'zip',
				'pdf',
				'jpeg',
				'jpg',
				'png',
				'doc',
				'docx',
				'ai',
				'eps',
                                'cdr'
			],
			'enable_ithenticate' => FALSE,
//			'comments_to_author' => true
			'enable_casrai_credits_confirm' => FALSE,
			'enable_orcid_confirm' => FALSE,
			'more_reviewers' => FALSE,
			'milestone_stage' => FALSE,
			'stage_for' => 'manageproduction',
			'prevent_edit' => false,
			'enable_research_integrity' => FALSE
		],
		'copy_editing' => [
			'label' => 'Copyediting',
			'assignment_tabs' => FALSE,
			'internal_statges' => [
				'ready_for_copy_editing' => 'Ready for %stage_name%',
				'copy_editing_in_progress' => '%stage_name% in Progress'
			],
			'roles' => [
				'copy_editor',
			],
			'child_stages' => [
				'type_setting'
			],
			'email_templates' => [
//					'article_tags',
//					'author_tags',
			],
			'possible_email_tmpl_actions' => [
				'initialization' => 'On stage initialization',
				'assigned' => 'On assignment/invitation',
				'unassign_user' => 'Unassign user',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On Reset',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
				],
			'multiple_child' => true,
			'default_assignment_type' => 'self_service',
			'assignment_options' => [
				'self_service',
				//'invitation',
				'manual'],
			'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
			'permission' => [
				'rescind',
				'reset',
			],
			'download' => [
				'production_package' => FALSE,
				'previous_files' => FALSE,
			],
			'upload_type' => 'required', //there is upload required
			'upload' => [
				'zip',
				'pdf',
				'doc',
				'docx',
                                'tif',
                                'tiff',
                                'jpg',
                                'jpeg',
			],
			'enable_ithenticate' => FALSE,
//			'comments_to_author' => true
			'enable_casrai_credits_confirm' => FALSE,
			'enable_orcid_confirm' => FALSE,
			'more_reviewers' => FALSE,
			'milestone_stage' => FALSE,
			'stage_for' => 'manageproduction',
			'prevent_edit' => false,
			'enable_research_integrity' => FALSE
		],
		'type_setting' => [
			'label' => 'Typesetting',
			'assignment_tabs' => FALSE,
			'internal_statges' => [
				'ready_for_type_setting' => 'Ready for %stage_name%',
				'type_setting_in_progress' => '%stage_name% in Progress'
			],
			'roles' => [
				'type_setter',
			],
			'child_stages' => [
				'proof_reading',
				'copy_editing',
				'postprocessing',
			],
			'email_templates' => [
//					'article_tags',
//					'author_tags',
			],
			'possible_email_tmpl_actions' => [
				'initialization' => 'On stage initialization',
				'assigned' => 'On assignment/invitation',
				'unassign_user' => 'Unassign user',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On Reset',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
				],
			'multiple_child' => true, 
			'default_assignment_type' => 'self_service',
			'assignment_options' => [
				'self_service',
				//'invitation',
				'manual'],
			'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
			'permission' => [
				'rescind',
				'reset',
			],
			'download' => [
				'production_package' => FALSE,
				'previous_files' => FALSE,
			],
			'upload_type' => 'required', //there is upload required
			'upload' => [
				'zip',
				'pdf',
                                'indd',
				'doc',
				'docx',
			],
			'list_allstage_files' => TRUE,
			'file_annotate' => TRUE,
//			'static_forms' => [
//				'type_setting'
//			],
			'enable_ithenticate' => FALSE,
//			'comments_to_author' => true
			'enable_casrai_credits_confirm' => FALSE,
			'enable_orcid_confirm' => FALSE,
			'more_reviewers' => FALSE,
			'milestone_stage' => FALSE,
			'stage_for' => 'manageproduction',
			'prevent_edit' => false,
			'enable_research_integrity' => FALSE
		],
		'proof_reading' => [
			'label' => 'Proofreading',
			'assignment_tabs' => FALSE,
			'internal_statges' => [
				'ready_for_proof_reading' => 'Ready for %stage_name%',
				'proof_reading_in_progress' => '%stage_name% in Progress'
			],
			'roles' => [
				'author',
				'proof_reader',
				'staff',
				'production_manager',
				'tsp',
				'editor_in_chief'
			],
			'child_stages' => [
				'editorial_process',
				'postprocessing',
				'proof_reading',
			],
			'email_templates' => [
//					'article_tags',
//					'author_tags',
			],
			'possible_email_tmpl_actions' => [
				'initialization' => 'On stage initialization',
				'assigned' => 'On assignment/invitation',
				'unassign_user' => 'Unassign user',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On Reset',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
				],
			'multiple_child' => true, 
			'default_assignment_type' => 'self_service',
			'assignment_options' => [
				'self_service',
				//'invitation',
				'manual'],
			'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
			'permission' => [
				'rescind',
				'reset',
			],
			'download' => [
				'production_package' => FALSE,
				'previous_files' => FALSE,
			],
			'upload_type' => 'optional', //there is may /may not upload
			'upload' => [
				'zip',
				'pdf',
				'doc',
				'docx',
			],
//			'static_forms' => [
//				'proof_reading'
//			],
			'enable_ithenticate' => FALSE,
//			'comments_to_author' => true
			'enable_casrai_credits_confirm' => FALSE,
			'enable_orcid_confirm' => FALSE,
			'more_reviewers' => FALSE,
			'milestone_stage' => FALSE,
			'stage_for' => 'manageproduction',
			'prevent_edit' => true,
			'enable_research_integrity' => FALSE
		],
		/*'editorial_manage' => [
			'label' => 'Production Management',
			'assignment_tabs' => FALSE,
			'internal_statges' => [
				'ready_for_editorial_manage' => 'Ready for %stage_name%',
				'editorial_manage_in_progress' => '%stage_name% in Progress'
			],
			'roles' => [
				'production_manager',
			],
			'child_stages' => [
				'publish',
				'proof_reading',
				'type_setting',
				'copy_editing',
			],
			'email_templates' => [
//					'article_tags',
//					'author_tags',
			],
			'possible_email_tmpl_actions' => [
				'initialization' => 'On stage initialization',
				'assigned' => 'On assignment/invitation',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On Reset',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
				],
			'multiple_child' => true, 
			'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
			'permission' => [
				'rescind',
				'reset',
			],
			'download' => [
				'production_package' => FALSE,
				'previous_files' => TRUE,
			],
			'upload_type' => 'optional', //there is may /may not upload
			'upload' => [
				'zip',
				'pdf',
				'jpeg',
				'jpg',
				'png',
				'doc',
				'docx',
			],
//			'static_forms' => [
//				'proof_reading'
//			],
			'enable_ithenticate' => FALSE,
//			'comments_to_author' => true
			'enable_casrai_credits_confirm' => FALSE,
			'enable_orcid_confirm' => FALSE,
			'more_reviewers' => FALSE,
			'stage_for' => 'manageproduction',
		],*/
		'postprocessing' => [
			'label' => 'Post processing',
			'assignment_tabs' => FALSE,
			'internal_statges' => [
				'ready_for_postprocessing' => 'Ready for %stage_name%',
				'postprocessing_in_progress' => '%stage_name% in Progress'
			],
			'roles' => [
				'production_manager',
				'tsp',
				'type_setter'
			],
			'child_stages' => [
				'publish',
				'postprocessing',
				'editorial_process',
				'proof_reading'
			],
			'email_templates' => [
//					'article_tags',
//					'author_tags',
			],
			'possible_email_tmpl_actions' => [
				'initialization' => 'On stage initialization',
				'assigned' => 'On assignment/invitation',
				'unassign_user' => 'Unassign user',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On Reset',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
				],
			'multiple_child' => true, 
			'default_assignment_type' => 'self_service',
			'assignment_options' => [
				'self_service',
				//'invitation',
				'manual'],
			'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
			'permission' => [
				'rescind',
				'reset',
			],
			'download' => [
				'production_package' => FALSE,
				'previous_files' => FALSE,
			],
			'upload_type' => 'optional', //there is may /may not upload
			'upload' => [
				'zip',
				'pdf',
				'jpeg',
				'jpg',
				'png',
				'doc',
				'docx',
                                'indd'
			],
			'list_allstage_files' => TRUE,
			'file_annotate' => TRUE,
//			'static_forms' => [
//				'proof_reading'
//			],
			'enable_ithenticate' => FALSE,
//			'comments_to_author' => true
			'enable_casrai_credits_confirm' => FALSE,
			'enable_orcid_confirm' => FALSE,
			'more_reviewers' => FALSE,
			'milestone_stage' => FALSE,
			'stage_for' => 'manageproduction',
			'prevent_edit' => false,
			'enable_research_integrity' => FALSE
		],
		'publish' => [
			'label' => 'Publish',
			'assignment_tabs' => FALSE,
			'internal_statges' => [
				'ready_for_publish' => 'Ready for %stage_name%',
				'publish_in_progress' => '%stage_name% in Progress'
			],
			'roles' => [
				'production_manager',
				'tsp',
				'type_setter',
			],
			'child_stages' => []
			,
			'email_templates' => [
//					'article_tags',
//					'author_tags',
			],
			'possible_email_tmpl_actions' => [
				'initialization' => 'On stage initialization',
				'assigned' => 'On assignment/invitation',
				'unassign_user' => 'Unassign user',
				'completed' => 'On complete',
				'rescind_source' => 'On rescind(source stage)',
				'rescind_destination' => 'On rescind(destination stage)',
				'reset' => 'On Reset',
				'accepted_not_completed' => 'Reminder to complete',
				'manual_reminder'=>'Manual reminder',
				],
			'multiple_child' => true, 
			'permission' => [
				'rescind',
				//'reset',
			],
			'generic_form' => -1, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
			'download' => [
				'production_package' => FALSE,
				'previous_files' => FALSE,
			],
			'file_annotate' => TRUE,
			//'upload_type' => 'optional', //there is may /may not upload
			'upload' => [],
			'enable_ithenticate' => FALSE,
//			'comments_to_author' => true
			'enable_casrai_credits_confirm' => FALSE,
			'enable_orcid_confirm' => FALSE,
			'more_reviewers' => FALSE,
			'milestone_stage' => FALSE,
			'stage_for' => 'manageproduction',
			'prevent_edit' => false,
			'enable_research_integrity' => FALSE
		],
	],
	'customdata' => [
		'te'=>[
			'textbox',
			'radiobutton'
		],
		'textarea'=>[
			'textbox',
			'radiobutton',
			'textarea'
        ],
	],
	'top_journal' => [
		'conf' => 40
	],
	'overriding_user_roles' => [
		'conference' => ['journal_admin']
	],
	'overriding_prevented_over' => [
		'conference' => ['author', 'reviewer']
	]
];
