<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class TbkDashboardSettings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbk_dashboard_settings', function (Blueprint $table) {
            $table->bigIncrements('tbk_id');
            $table->bigInteger('ds_id');
            $table->bigInteger('ds_jnl_id');
            $table->bigInteger('ds_role_id');
            $table->text('ds_features')->nullable()->collation('utf8_unicode_ci');
            $table->bigInteger('ds_posted_by');
            $table->dateTime('ds_posted_date');
            $table->bigInteger('ds_proxy_id');
            $table->char('ds_operation',1)->comment('u-update,i-insert')->collation('utf8_unicode_ci');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('tbk_dashboard_settings');
    }
}
