<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        // DB::beginTransaction();
        try {
            DB::statement("CREATE TABLE `rvw_classifications` (
                `cls_id` bigint(20) UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT,
                `cls_jnl_id` int(10) UNSIGNED NOT NULL COMMENT 'pk of rvw_journals',
                `cls_term_id` bigint(20) UNSIGNED NOT NULL,
                `cls_primary_id` bigint(20) UNSIGNED DEFAULT NULL COMMENT 'pk of rvw_classifications (self reference)',
                `cls_parents_id` text COLLATE utf8_unicode_ci  NULL COMMENT 'all parent nodes\r\n',
                `cls_children_id` text COLLATE utf8_unicode_ci  NULL  COMMENT 'all child nodes\r\n',
                `cls_artp_id` int(10) UNSIGNED DEFAULT NULL COMMENT 'pk of rvw_article_types (only in article type area)',
                `cls_posted_by` bigint(20) UNSIGNED NOT NULL,
                `cls_posted_date` datetime NOT NULL,
                `cls_old_cls_id` bigint(20) UNSIGNED DEFAULT NULL COMMENT 'temp field for article type copy time',
                `cls_proxy_id` bigint(20) NOT NULL,
                `cls_operation` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert'
              ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;");



DB::statement("ALTER TABLE `rvw_classifications`
ADD KEY `cls_jnl_id` (`cls_jnl_id`),
ADD KEY `cls_term_id` (`cls_term_id`),
ADD KEY `cls_primary_id` (`cls_primary_id`),
ADD KEY `cls_artp_id` (`cls_artp_id`),
ADD KEY `cls_posted_by` (`cls_posted_by`),
ADD KEY `cls_proxy_id` (`cls_proxy_id`),
ADD KEY `cls_posted_by_2` (`cls_posted_by`),
ADD KEY `cls_proxy_id_2` (`cls_proxy_id`)");

            DB::statement("CREATE TABLE `tbk_classifications` (
    `cls_id` bigint(20) UNSIGNED NOT NULL ,
    `cls_jnl_id` int(10) UNSIGNED NOT NULL COMMENT 'pk of rvw_journals',
    `cls_term_id` bigint(20) UNSIGNED NOT NULL,
    `cls_primary_id` bigint(20) UNSIGNED DEFAULT NULL COMMENT 'pk of rvw_classifications (self reference)',
    `cls_parents_id` text COLLATE utf8_unicode_ci  NULL COMMENT 'all parent nodes\r\n',
    `cls_children_id` text COLLATE utf8_unicode_ci  NULL  COMMENT 'all child nodes\r\n',
    `cls_artp_id` int(10) UNSIGNED DEFAULT NULL COMMENT 'pk of rvw_article_types (only in article type area)',
    `cls_posted_by` bigint(20) UNSIGNED NOT NULL,
    `cls_posted_date` datetime NOT NULL,
    `cls_old_cls_id` bigint(20) UNSIGNED DEFAULT NULL COMMENT 'temp field for article type copy time',
    `cls_proxy_id` bigint(20) NOT NULL,
    `cls_operation` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
                `tbk_id` BIGINT(20) UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT 
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;");



            DB::statement("ALTER TABLE `tbk_classifications`            
            ADD KEY `cls_jnl_id` (`cls_jnl_id`),
            ADD KEY `cls_id` (`cls_id`),
            ADD KEY `cls_term_id` (`cls_term_id`),
            ADD KEY `cls_primary_id` (`cls_primary_id`),
            ADD KEY `cls_artp_id` (`cls_artp_id`),
            ADD KEY `cls_posted_by` (`cls_posted_by`),
            ADD KEY `cls_proxy_id` (`cls_proxy_id`),
            ADD KEY `cls_posted_by_2` (`cls_posted_by`),
            ADD KEY `cls_proxy_id_2` (`cls_proxy_id`)");

            DB::unprepared('
CREATE TRIGGER trg_classifications_after_insert AFTER INSERT ON `rvw_classifications` FOR EACH ROW
BEGIN
INSERT INTO tbk_classifications SELECT *,NULL tbk_id FROM rvw_classifications WHERE cls_id= NEW.cls_id;
END
');
            DB::unprepared("
CREATE TRIGGER trg_classifications_after_update AFTER UPDATE ON `rvw_classifications` FOR EACH ROW
BEGIN
IF NEW.jpm_operation != 'm'  THEN
INSERT INTO tbk_classifications SELECT *,NULL tbk_id FROM rvw_classifications WHERE jpm_id= OLD.jpm_id;
END IF;
END
");
        } catch (\Exception $e) {
            // DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('rvw_classifications');
        Schema::drop('tbk_classifications');
    }
};
