<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('rvw_email_send_log', 'esl_trans_mode')) {
            DB::statement("ALTER TABLE `rvw_email_send_log` ADD `esl_trans_mode` CHAR(1) NULL DEFAULT 's' COMMENT 's=send,r=receive' AFTER `esl_is_forward`");
        }
        if (!Schema::hasColumn('tbk_email_send_log', 'esl_trans_mode')) {
            DB::statement("ALTER TABLE `tbk_email_send_log` ADD `esl_trans_mode` CHAR(1) NULL DEFAULT 's' COMMENT 's=send,r=receive' AFTER `esl_is_forward`");
        }
        if (!Schema::hasColumn('rvw_email_send_log', 'esl_read_status')) {
            DB::statement("ALTER TABLE `rvw_email_send_log` ADD `esl_read_status` CHAR(1) NULL DEFAULT NULL COMMENT 'r=read,u=unread,s=reply send mail' AFTER `esl_trans_mode`");
        }
        if (!Schema::hasColumn('tbk_email_send_log', 'esl_read_status')) {
            DB::statement("ALTER TABLE `tbk_email_send_log` ADD `esl_read_status` CHAR(1) NULL DEFAULT NULL  COMMENT 'r=read,u=unread,s=reply send mail'AFTER `esl_trans_mode`");
        }
        if (!Schema::hasColumn('rvw_email_send_log', 'esl_trans_secret_id')) {
            DB::statement("ALTER TABLE `rvw_email_send_log` ADD `esl_trans_secret_id` TEXT NULL DEFAULT NULL COMMENT 'dynamic secret id / NULL' AFTER `esl_read_status`");
        }
        if (!Schema::hasColumn('tbk_email_send_log', 'esl_trans_secret_id')) {
            DB::statement("ALTER TABLE `tbk_email_send_log` ADD `esl_trans_secret_id` TEXT NULL DEFAULT NULL COMMENT 'dynamic secret id / NULL' AFTER `esl_read_status`");
        }
        //  DB::statement("INSERT INTO `rvw_client_functionalities` (`cfty_id`, `cfty_clnt_id`, `cfty_functionality`, `cfty_status`, `cfty_posted_date`, `cfty_posted_by`, `cfty_proxy_id`, `cfty_operation`) VALUES (NULL, '1', 'cfty_receive_email_response', 'n', '2023-11-08 13:02:24', '0', NULL, '');");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::statement("ALTER TABLE `rvw_email_send_log` DROP `esl_trans_mode`,DROP `esl_read_status`,DROP `esl_trans_secret_id`");
        DB::statement("ALTER TABLE `tbk_email_send_log` DROP `esl_trans_mode`,DROP `esl_read_status`,DROP `esl_trans_secret_id`");
    }
};
