<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::beginTransaction();
        try
        {  
            DB::statement("ALTER TABLE `rvw_author_affiliation` ADD `auaff_state` VARCHAR(100)  CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL AFTER `auaff_ringgold_family`");
            DB::statement("ALTER TABLE `tbk_author_affiliation` ADD `auaff_state` VARCHAR(100)  CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL AFTER `auaff_ringgold_family`");
        }
        catch(\Exception $e)
        {
            DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('rvw_author_affiliation', function (Blueprint $table) {
            if (Schema::hasColumn('rvw_author_affiliation','auaff_state')) {
                $table->dropColumn('auaff_state');
            }
        });

        Schema::table('tbk_author_affiliation', function (Blueprint $table) {
            if (Schema::hasColumn('tbk_author_affiliation','auaff_state')) {
                $table->dropColumn('auaff_state');
            }
        });

    }
};
