<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try {
            DB::statement("CREATE TABLE `rvw_currency_master` (
                `curr_id` bigint NOT NULL AUTO_INCREMENT,
                `curr_name` varchar(50) NOT NULL,
                `curr_symbol` varchar(10) NOT NULL,
                PRIMARY KEY (`curr_id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci");
            
            DB::statement("CREATE TABLE `tbk_currency_master` (
                `curr_id` bigint NOT NULL,
                `curr_name` varchar(50) NOT NULL,
                `curr_symbol` varchar(10) NOT NULL,
                `tbk_id` bigint NOT NULL AUTO_INCREMENT,
                PRIMARY KEY (`tbk_id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci");

            DB::unprepared("CREATE TRIGGER trg_rvw_currency_master_after_insert AFTER INSERT ON `rvw_currency_master` FOR EACH ROW BEGIN INSERT INTO `tbk_currency_master` SELECT *, NULL AS tbk_id FROM `rvw_currency_master` WHERE `curr_id` = NEW.`curr_id`; END;");

            DB::unprepared("CREATE TRIGGER trg_rvw_currency_master_after_update AFTER UPDATE ON `rvw_currency_master` FOR EACH ROW BEGIN INSERT INTO `tbk_currency_master` SELECT *, NULL AS tbk_id FROM `rvw_currency_master` WHERE `curr_id` = OLD.`curr_id`; END;");

            DB::statement("INSERT INTO `rvw_currency_master` (`curr_id`, `curr_name`, `curr_symbol`) VALUES
                (1, 'United States Dollar', '$'),
                (2, 'Euro', '€'),
                (3, 'British Pound', '£'),
                (4, 'Japanese Yen', '¥'),
                (5, 'Swiss Franc', 'CHF'),
                (6, 'Australian Dollar', 'AU$'),
                (7, 'Canadian Dollar', 'CA$'),
                (8, 'Chinese Yuan', '¥'),
                (9, 'Indian Rupee', '₹');"
            );

        } catch (\Exception $e) {
            DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rvw_currency_master');
        Schema::dropIfExists('tbk_currency_master');
    }
};
