<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('rvw_articles', function (Blueprint $table) {
            $table->bigInteger('art_absc_id', false, true)->nullable()->after('art_abstract');
            $table->foreign('art_absc_id')->references('absc_id')->on('rvw_abstract_categories')->onDelete('cascade')->onUpdate('cascade');
        });
        Schema::table('tbk_articles', function (Blueprint $table) {
            $table->bigInteger('art_absc_id', false, true)->nullable()->after('art_abstract');
            $table->foreign('art_absc_id')->references('absc_id')->on('rvw_abstract_categories')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('rvw_articles', function (Blueprint $table) {
            $table->dropForeign('rvw_articles_art_absc_id_foreign');
            $table->dropColumn('art_adsc_id');
        });
        Schema::table('tbk_articles', function (Blueprint $table) {
            $table->dropForeign('tbk_articles_art_absc_id_foreign');
            $table->dropColumn('art_absc_id');
        });
    }
};
