<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try {
            DB::statement("ALTER TABLE `rvw_journal_workflows` ADD `jwf_enable_payment` VARCHAR(1) NOT NULL DEFAULT 'n' AFTER `jwf_button_title`, ADD `jwf_curr_id` BIGINT NULL COMMENT 'pk of rvw_currency_master' AFTER `jwf_enable_payment`, ADD `jwf_payment_fees` BIGINT NULL AFTER `jwf_curr_id`;");
            DB::statement("ALTER TABLE `tbk_journal_workflows` ADD `jwf_enable_payment` VARCHAR(1) NOT NULL DEFAULT 'n' AFTER `jwf_button_title`, ADD `jwf_curr_id` BIGINT NULL COMMENT 'pk of rvw_currency_master' AFTER `jwf_enable_payment`, ADD `jwf_payment_fees` BIGINT NULL AFTER `jwf_curr_id`;");
            
            DB::unprepared("UPDATE `rvw_currency_master` SET `curr_code` = 'USD' WHERE `rvw_currency_master`.`curr_id` = 1; UPDATE `rvw_currency_master` SET `curr_code` = 'EUR' WHERE `rvw_currency_master`.`curr_id` = 2; UPDATE `rvw_currency_master` SET `curr_code` = 'GBP' WHERE `rvw_currency_master`.`curr_id` = 3; UPDATE `rvw_currency_master` SET `curr_code` = 'JPY' WHERE `rvw_currency_master`.`curr_id` = 4; UPDATE `rvw_currency_master` SET `curr_code` = 'CHF' WHERE `rvw_currency_master`.`curr_id` = 5; UPDATE `rvw_currency_master` SET `curr_code` = 'AUD' WHERE `rvw_currency_master`.`curr_id` = 6; UPDATE `rvw_currency_master` SET `curr_code` = 'CAD' WHERE `rvw_currency_master`.`curr_id` = 7; UPDATE `rvw_currency_master` SET `curr_code` = 'CNY' WHERE `rvw_currency_master`.`curr_id` = 8;UPDATE `rvw_currency_master` SET `curr_code` = 'INR' WHERE `rvw_currency_master`.`curr_id` = 9;"
            );
        } catch (\Exception $e) {
            DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('rvw_journal_workflows', function (Blueprint $table) {
            if (Schema::hasColumn('rvw_journal_workflows','jwf_enable_payment')) {
                $table->dropColumn('jwf_enable_payment');
            }
            if (Schema::hasColumn('rvw_journal_workflows','jwf_curr_id')) {
                $table->dropColumn('jwf_curr_id');
            }
            if (Schema::hasColumn('rvw_journal_workflows','jwf_payment_fees')) {
                $table->dropColumn('jwf_payment_fees');
            }
        });
        Schema::table('tbk_journal_workflows', function (Blueprint $table) {
            if (Schema::hasColumn('tbk_journal_workflows','jwf_enable_payment')) {
                $table->dropColumn('jwf_enable_payment');
            }
            if (Schema::hasColumn('tbk_journal_workflows','jwf_curr_id')) {
                $table->dropColumn('jwf_curr_id');
            }
            if (Schema::hasColumn('tbk_journal_workflows','jwf_payment_fees')) {
                $table->dropColumn('jwf_payment_fees');
            }
        });
    }
};
