<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $table_exist = Schema::connection('mysql_common')->hasTable('rvw_all_clients');
        if (!$table_exist) {
            Schema::connection('mysql_common')->create('rvw_all_clients', function (Blueprint $table) {
                $table->id('acls_id');
                $table->string('acls_client_name', 50);
                $table->string('acls_client_code', 50);
                $table->dateTime('acls_posted_date');
                $table->unsignedBigInteger('acls_posted_by');
                $table->unsignedBigInteger('acls_proxy_id')->nullable();
                $table->char('acls_operation', 1);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rvw_all_clients');
    }
};
