<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('rvw_journal_settings', 'jset_title_length')) {
            Schema::table('rvw_journal_settings', function (Blueprint $table) {
                $table->integer('jset_title_length')->default(250)->comment('length of title')->after('jset_paper_length');
            });
        }
        if (!Schema::hasColumn('tbk_journal_settings', 'jset_title_length')) {
            Schema::table('tbk_journal_settings', function (Blueprint $table) {
                $table->integer('jset_title_length')->default(250)->comment('length of title')->after('jset_paper_length');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_journal_settings', 'jset_title_length')) {
            Schema::table('rvw_journal_settings', function (Blueprint $table) {
                $table->dropColumn('jset_title_length');
            });
        }
        if (Schema::hasColumn('tbk_journal_settings', 'jset_title_length')) {
            Schema::table('tbk_journal_settings', function (Blueprint $table) {
                $table->dropColumn('jset_title_length');
            });
        }
    }
};
