<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try {
            DB::statement("INSERT INTO `rvw_general_permissions` (`id`, `permission_route`, `permission_parent_route`, `permission_caption`, `permission_icon`, `permission_roles`, `permission_posted_by`, `permission_posted_date`, `permission_proxy_id`, `permission_operation`) VALUES (NULL, 'manage-reports', 'manage-reports', 'Manage Reports', 'tasks ', '[\"\", \"super_admin\"]', '1', '2023-11-28 09:22:00', '1', 'u')");
            DB::statement("DELETE FROM `rvw_general_permissions` WHERE `permission_route` = 'view-report'");
            DB::statement("DELETE FROM `rvw_reports` WHERE `rep_title` = '' AND `rep_operation` = 'm';");
            DB::statement("UPDATE rvw_reports SET `rep_type` = REPLACE(`rep_type`, '_summary', '') WHERE `rep_type` LIKE '%summary%';");           
            DB::statement("CREATE TABLE IF NOT EXISTS `tbk_report_folders` (
                `rfld_id` bigint UNSIGNED NOT NULL,
                `rfld_parent_id` bigint DEFAULT NULL,
                `rfld_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
                `rfld_posted_by` bigint DEFAULT NULL,
                `rfld_posted_date` datetime NOT NULL,
                `rfld_proxy_id` bigint DEFAULT NULL,
                `rfld_operation` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'u',
                `tbk_id` bigint UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
            ");
            DB::unprepared('
                CREATE TRIGGER trg_report_folders_after_insert AFTER INSERT ON `rvw_report_folders` FOR EACH ROW
                BEGIN
                INSERT INTO tbk_report_folders SELECT *,NULL tbk_id FROM rvw_report_folders WHERE rfld_id= NEW.rfld_id;
                END
            ');
            DB::unprepared("
                CREATE TRIGGER trg_report_folders_after_update AFTER UPDATE ON `rvw_report_folders` FOR EACH ROW
                BEGIN
                IF (NEW.rfld_operation != 'm') THEN INSERT INTO tbk_report_folders SELECT *,NULL tbk_id FROM rvw_report_folders WHERE rfld_id= OLD.rfld_id;
                END IF;
                END
            ");  
            } catch (\Exception $e) {
            DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
