<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $table_exist = Schema::connection('mysql_common')->hasTable('rvw_note_attachment');
        if (!$table_exist) {
            Schema::connection('mysql_common')->create('rvw_note_attachment', function (Blueprint $table) {
            $table->id('noteattch_id');
            $table->integer('noteattch_note_id', false, true)->comment('pk of rvw_release_notes');
            $table->string('noteattch_name',1000);
            $table->string('noteattch_size',500);
            $table->unsignedBigInteger('noteattch_posted_by');
            $table->dateTime('noteattch_posted_date');
            $table->unsignedBigInteger('noteattch_proxy_id')->nullable();
            $table->char('noteattch_operation', 1);

        });
    }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('rvw_note_attachment', function (Blueprint $table) {
            //
            Schema::dropIfExists('rvw_note_label');
        });
    }
};
