<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('rvw_journal_workflows', 'jwf_scroll_viewarticle')) {
            DB::statement("ALTER TABLE `rvw_journal_workflows` ADD `jwf_scroll_viewarticle` CHAR(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'y - Yes, n - No' AFTER `jwf_enable_payment`");
        }
        if (!Schema::hasColumn('tbk_journal_workflows', 'jwf_scroll_viewarticle')) {
            DB::statement("ALTER TABLE `tbk_journal_workflows` ADD `jwf_scroll_viewarticle` CHAR(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'y - Yes, n - No' AFTER `jwf_enable_payment`");
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_journal_workflows', 'jwf_scroll_viewarticle')) {
            DB::statement("ALTER TABLE `rvw_journal_workflows` DROP `jwf_scroll_viewarticle`");
        }
        if (Schema::hasColumn('tbk_journal_workflows', 'jwf_scroll_viewarticle')) {
            DB::statement("ALTER TABLE `tbk_journal_workflows` DROP `jwf_scroll_viewarticle`");
        }
    }
};
