<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Models\Generic_form_elements;
return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try
        {
            if (!Schema::hasColumn('rvw_generic_form_elements', 'emt_populate_data_pair')) {
            DB::statement("ALTER TABLE `rvw_generic_form_elements` ADD `emt_populate_data_pair`  JSON NULL DEFAULT NULL COMMENT 'element populate data pair' AFTER `emt_source_elementid`");
            }
            if (!Schema::hasColumn('tbk_generic_form_elements', 'emt_populate_data_pair')) {
                DB::statement("ALTER TABLE `tbk_generic_form_elements` ADD `emt_populate_data_pair`  JSON NULL DEFAULT NULL COMMENT 'element populate data pair' AFTER `emt_source_elementid`");
                }
                $records = Generic_form_elements::select('emt_id', 'emt_source_formid', 'emt_source_elementid')
                            ->whereNotNull('emt_source_formid')
                            ->where('emt_source_formid', '!=', 0)
                            ->whereNotNull('emt_source_elementid')
                            ->where('emt_source_elementid', '!=', 0)
                            ->get();

                            foreach ($records as $record) {
                                $populateData =
                                    [ 
                                        $record->emt_source_formid => ["" . (string)$record->emt_source_elementid] // The associative array inside
                                    ];
                            
                                $jsonData = json_encode([$populateData]); 

                                Generic_form_elements::where('emt_id', $record->emt_id)->update([
                                    'emt_populate_data_pair' => $jsonData,
                                ]);
                            }
        }
        catch(\Exception $e)
        {
            Log::warning("alterpopulatedata feild failed");
            Log::warning($e->getMessage());
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_generic_form_elements', 'emt_populate_data_pair')) {
            DB::statement("ALTER TABLE `rvw_generic_form_elements` DROP `emt_populate_data_pair`");
        }
        if (Schema::hasColumn('tbk_generic_form_elements', 'emt_populate_data_pair')) {
            DB::statement("ALTER TABLE `tbk_generic_form_elements` DROP `emt_populate_data_pair`");
        }
    }
};
