<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('rvw_journal_permission', function (Blueprint $table) {
            $table->json('jp_imported_article_assigner')->after('jp_request_rescind')->nullable();
            $table->json('jp_import_article')->after('jp_request_rescind')->nullable();
        });
        Schema::table('tbk_journal_permission', function (Blueprint $table) {
            $table->json('jp_imported_article_assigner')->after('jp_request_rescind')->nullable();
            $table->json('jp_import_article')->after('jp_request_rescind')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('rvw_journal_permission', function (Blueprint $table) {
            $table->dropColumn('jp_imported_article_assigner');
            $table->dropColumn('jp_import_article');
        });
        Schema::table('tbk_journal_permission', function (Blueprint $table) {
            $table->dropColumn('jp_imported_article_assigner');
            $table->dropColumn('jp_import_article');
        });
    }
};
