<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Task #42 taskbot TASK #10131 Make Postal Code Field Optional in User Registration Form
        $table_exist = Schema::connection('mysql_common')->hasTable('rvw_client_fieldvalidation');
        if (!$table_exist) {
            Schema::create('rvw_client_fieldvalidation', function (Blueprint $table) {
                $table->bigIncrements('cfv_id'); // Auto-incrementing primary key
                $table->string('cfv_validate_fields', 100)->unique(); // Unique field
                $table->char('cfv_status', 1)->default('n')->comment('y-yes,n-no'); // Status field with default value
                $table->dateTime('cfv_posted_date')->nullable(); // Nullable datetime field
                $table->bigInteger('cfv_posted_by'); // Posted by field
                $table->bigInteger('cfv_proxy_id')->nullable(); // Nullable proxy ID field
                $table->char('cfv_operation', 1); // Operation field
            });
        }
        $table_exist_tbk = Schema::connection('mysql_common')->hasTable('tbk_client_fieldvalidation');
        if (!$table_exist_tbk) {
            Schema::create('tbk_client_fieldvalidation', function (Blueprint $table) {
                $table->bigInteger('cfv_id');
                $table->string('cfv_validate_fields', 100); // Unique field
                $table->char('cfv_status', 1)->default('n')->comment('y-yes,n-no'); // Status field with default value
                $table->dateTime('cfv_posted_date')->nullable(); // Nullable datetime field
                $table->bigInteger('cfv_posted_by'); // Posted by field
                $table->bigInteger('cfv_proxy_id')->nullable(); // Nullable proxy ID field
                $table->char('cfv_operation', 1); // Operation field
                $table->bigIncrements('tbk_id'); // Auto-incrementing primary key
            });
        }

        DB::unprepared('
        CREATE TRIGGER trg_client_fieldvalidation_after_insert AFTER INSERT ON `rvw_client_fieldvalidation` FOR EACH ROW
        BEGIN
        INSERT INTO tbk_client_fieldvalidation SELECT *,NULL tbk_id FROM rvw_client_fieldvalidation WHERE cfv_id= NEW.cfv_id;
        END
        ');
        DB::unprepared("
        CREATE TRIGGER trg_client_fieldvalidation_after_update AFTER UPDATE ON `rvw_client_fieldvalidation` FOR EACH ROW
        BEGIN
        IF NEW.cfv_operation != 'm'  THEN 
        INSERT INTO tbk_client_fieldvalidation SELECT *,NULL tbk_id FROM rvw_client_fieldvalidation WHERE cfv_id= OLD.cfv_id;
        END IF;
        END
        ");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rvw_client_fieldvalidation');
        Schema::dropIfExists('tbk_client_fieldvalidation');
    }
};
