<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::statement("ALTER TABLE `rvw_journal_permission` ADD `jp_suspecious_activity` JSON NULL DEFAULT NULL COMMENT 'suspecious activity' AFTER `jp_reinstantiate_payment`;");
        DB::statement("ALTER TABLE `tbk_journal_permission` ADD `jp_suspecious_activity` JSON NULL DEFAULT NULL COMMENT 'suspecious activity' AFTER `jp_reinstantiate_payment`;");
        DB::statement("CREATE TABLE `rvw_suspecious_activity` (`sup_id` BIGINT NOT NULL AUTO_INCREMENT , `sup_art_id` BIGINT UNSIGNED NOT NULL , `sup_usr_id` BIGINT UNSIGNED NOT NULL , `sup_role_id` BIGINT UNSIGNED NULL,`sup_aflw_id` BIGINT UNSIGNED NOT NULL , `sup_ltk_id` BIGINT UNSIGNED NOT NULL ,`sup_ref_ltk_id` BIGINT UNSIGNED NOT NULL,`sus_flag_status` CHAR(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT 'n' COMMENT 'n=not flaged user,y=flaged user',`sup_submission_date` DATETIME NULL DEFAULT NULL,`sup_posted_by` BIGINT NULL , `sup_posted_date` DATETIME NULL ,`sup_proxy_id` BIGINT NOT NULL, `sup_operation` CHAR(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT 'u' COMMENT ' u-update,i-insert ' , PRIMARY KEY (`sup_id`))  ENGINE = InnoDB; ");
        DB::statement("CREATE TABLE `tbk_suspecious_activity` (`sup_id` BIGINT UNSIGNED NOT NULL, `sup_art_id` BIGINT UNSIGNED NOT NULL , `sup_usr_id` BIGINT UNSIGNED NOT NULL ,`sup_role_id` BIGINT UNSIGNED NULL ,`sup_aflw_id` BIGINT UNSIGNED NOT NULL , `sup_ltk_id` BIGINT UNSIGNED NOT NULL ,`sup_ref_ltk_id` BIGINT UNSIGNED NOT NULL,`sus_flag_status` CHAR(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT 'n',`sup_submission_date` DATETIME NULL DEFAULT NULL,`sup_posted_by` BIGINT NULL , `sup_posted_date` DATETIME NULL ,`sup_proxy_id` BIGINT NOT NULL ,`sup_operation` CHAR(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT 'u' COMMENT ' u-update,i-insert ' ,`tbk_id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,PRIMARY KEY (`tbk_id`))  ENGINE = InnoDB; ");
        DB::statement("ALTER TABLE `rvw_suspecious_activity` ADD INDEX(`sup_art_id`);");
        DB::statement("ALTER TABLE `rvw_suspecious_activity` ADD INDEX(`sup_usr_id`);");
        DB::statement("ALTER TABLE `rvw_suspecious_activity` ADD INDEX(`sup_aflw_id`);");
        DB::statement("ALTER TABLE `rvw_suspecious_activity` ADD INDEX(`sup_ltk_id`);");
        DB::statement("ALTER TABLE `rvw_suspecious_activity` ADD INDEX(`sup_ref_ltk_id`);");
        DB::statement("ALTER TABLE `rvw_suspecious_activity` ADD INDEX(`sup_role_id`);");

       Schema::table('rvw_suspecious_activity', function (Blueprint $table) {
        $table->foreign('sup_art_id')->references('art_id')->on('rvw_articles')->onDelete('cascade')->onUpdate('cascade');
    });

    Schema::table('rvw_suspecious_activity', function (Blueprint $table) {
        $table->foreign('sup_aflw_id')->references('aflw_id')->on('rvw_article_flow')->onDelete('cascade')->onUpdate('cascade');
    });

    Schema::table('rvw_suspecious_activity', function (Blueprint $table) {
        $table->foreign('sup_usr_id')->references('usr_id')->on('rvw_users')->onDelete('cascade')->onUpdate('cascade');
    });

    Schema::table('rvw_suspecious_activity', function (Blueprint $table) {
        $table->foreign('sup_ltk_id')->references('ltk_id')->on('rvw_login_tracking')->onDelete('cascade')->onUpdate('cascade');
    });
        DB::statement("CREATE TRIGGER `trg_suspecious_after_insert` AFTER INSERT ON `rvw_suspecious_activity`
 FOR EACH ROW INSERT INTO tbk_suspecious_activity SELECT *,NULL tbk_id FROM rvw_suspecious_activity WHERE sup_id= NEW.sup_id");
        DB::statement("CREATE TRIGGER trg_suspecious_after_update AFTER UPDATE ON `rvw_suspecious_activity` FOR EACH ROW BEGIN IF NEW.sup_operation != 'm' THEN INSERT INTO tbk_suspecious_activity SELECT *,NULL tbk_id FROM rvw_suspecious_activity WHERE sup_id= OLD.sup_id; END IF; END;");

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
