<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try
        {
            if (!Schema::hasColumn('rvw_journal_settings', 'jset_research_integrity')) {
                DB::statement("ALTER TABLE `rvw_journal_settings` ADD `jset_research_integrity` CHAR(1) NOT NULL DEFAULT 'n' COMMENT 'Y-enabled in journal, N-not enabled' AFTER `jset_jats_export`");
            }
            if (!Schema::hasColumn('tbk_journal_settings', 'jset_research_integrity')) {
                DB::statement("ALTER TABLE `tbk_journal_settings` ADD `jset_research_integrity` CHAR(1) NOT NULL DEFAULT 'n' COMMENT 'Y-enabled in journal, N-not enabled' AFTER `jset_jats_export`");
            }
        }
        catch(\Exception $e)
        {
            Log::warning("Adding new column:jset_research_integrity failed in journal settings table");
            Log::warning($e->getMessage());
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_journal_settings', 'jset_research_integrity')) {
            DB::statement("ALTER TABLE `rvw_journal_settings` DROP `jset_research_integrity`");
        }
        if (Schema::hasColumn('tbk_journal_settings', 'jset_research_integrity')) {
            DB::statement("ALTER TABLE `tbk_journal_settings` DROP `jset_research_integrity`");
        }
    }
};
