<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try
        {
            if (!Schema::hasColumn('rvw_article_type_advance_options', 'atotp_rvrisubmission_type')) {
                DB::statement("ALTER TABLE `rvw_article_type_advance_options` ADD `atotp_rvrisubmission_type` VARCHAR(6) NOT NULL COMMENT 'auto or manual' AFTER `atotp_research_integrity`");
            }
            if (!Schema::hasColumn('tbk_article_type_advance_options', 'atotp_rvrisubmission_type')) {
                DB::statement("ALTER TABLE `tbk_article_type_advance_options` ADD `atotp_rvrisubmission_type` VARCHAR(6) NOT NULL COMMENT 'auto or manual' AFTER `atotp_research_integrity`");
            }

            if (!Schema::hasColumn('rvw_article_type_advance_options', 'atotp_rvriauto_submissions')) {
                DB::statement("ALTER TABLE `rvw_article_type_advance_options` ADD `atotp_rvriauto_submissions` MEDIUMTEXT NULL DEFAULT NULL AFTER `atotp_rvrisubmission_type`");
            }
            if (!Schema::hasColumn('tbk_article_type_advance_options', 'atotp_rvriauto_submissions')) {
                DB::statement("ALTER TABLE `tbk_article_type_advance_options` ADD `atotp_rvriauto_submissions` MEDIUMTEXT NULL DEFAULT NULL AFTER `atotp_rvrisubmission_type`");
            }
        }
        catch(\Exception $e)
        {
            Log::warning("Adding new column:atotp_rvrisubmission_type/atotp_rvriauto_submissions failed in article type settings table");
            Log::warning($e->getMessage());
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_article_type_advance_options', 'atotp_rvrisubmission_type')) {
            DB::statement("ALTER TABLE `rvw_article_type_advance_options` DROP `atotp_rvrisubmission_type`");
        }
        if (Schema::hasColumn('tbk_article_type_advance_options', 'atotp_rvrisubmission_type')) {
            DB::statement("ALTER TABLE `tbk_article_type_advance_options` DROP `atotp_rvrisubmission_type`");
        }

        if (Schema::hasColumn('rvw_article_type_advance_options', 'atotp_rvriauto_submissions')) {
            DB::statement("ALTER TABLE `rvw_article_type_advance_options` DROP `atotp_rvriauto_submissions`");
        }
        if (Schema::hasColumn('tbk_article_type_advance_options', 'atotp_rvriauto_submissions')) {
            DB::statement("ALTER TABLE `tbk_article_type_advance_options` DROP `atotp_rvriauto_submissions`");
        }
    }
};
