<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try
        {
            if (!Schema::hasColumn('rvw_research_integrity_reports', 'rri_status')) {
                DB::statement("ALTER TABLE `rvw_research_integrity_reports` ADD `rri_status` CHAR(1) NULL COMMENT 'n - not generated ; y - generated' AFTER `rri_report`;");
            }
        }
        catch(\Exception $e)
        {
            Log::warning("Adding new column:rri_status failed in rvw_research_integrity_reports table");
            Log::warning($e->getMessage());
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_research_integrity_reports', 'rri_status')) {
            DB::statement("ALTER TABLE `rvw_research_integrity_reports` DROP `rri_status`");
        }
    }
};
