<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try
        {
            // Check if the column exists before attempting to drop it
            $columnExists1 = DB::select("SHOW COLUMNS FROM rvw_research_integrity_reports LIKE 'rri_art_aflw_id'");
            if ($columnExists1) {
                DB::statement("ALTER TABLE rvw_research_integrity_reports DROP COLUMN rri_art_aflw_id;");
            }

            $columnExists2 = DB::select("SHOW COLUMNS FROM tbk_research_integrity_reports LIKE 'rri_art_aflw_id'");
            if ($columnExists2) {
                DB::statement("ALTER TABLE tbk_research_integrity_reports DROP COLUMN rri_art_aflw_id;");
            }

            DB::statement("ALTER TABLE `rvw_research_integrity_reports` ADD `rri_aflw_id` bigint UNSIGNED NOT NULL AFTER `rri_art_id`");
            DB::statement("ALTER TABLE `tbk_research_integrity_reports` ADD `rri_aflw_id` bigint UNSIGNED NOT NULL AFTER `rri_art_id`");
        }

        catch(\Exception $e)
        {
            DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::statement("ALTER TABLE `rvw_research_integrity_reports` DROP `rri_aflw_id`");
        DB::statement("ALTER TABLE `tbk_research_integrity_reports` DROP `rri_aflw_id`");
    }
};
