<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('rvw_ftp_locations', function (Blueprint $table) {
            Schema::table('rvw_ftp_locations', function (Blueprint $table) {
                $table->char('ftp_ext_location', 1)
                      ->nullable()
                      ->default('n')
                      ->comment('y=yes,n=no')
                      ->after('ftp_metadata_on_export');
            });
        });
        Schema::table('tbk_ftp_locations', function (Blueprint $table) {
            Schema::table('tbk_ftp_locations', function (Blueprint $table) {
                $table->char('ftp_ext_location', 1)
                      ->nullable()
                      ->default('n')
                      ->comment('y=yes,n=no')
                      ->after('ftp_metadata_on_export');
            });
        });
        Schema::table('rvw_ftp_master', function (Blueprint $table) {
            if (Schema::hasColumn('rvw_ftp_master','ftpm_ext_location')) {
                $table->dropColumn('ftpm_ext_location');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('rvw_ftp_locations', function (Blueprint $table) {
            if (Schema::hasColumn('rvw_ftp_locations','ftp_ext_location')) {
                $table->dropColumn('ftp_ext_location');
            }
        });
        Schema::table('tbk_ftp_locations', function (Blueprint $table) {
            if (Schema::hasColumn('tbk_ftp_locations','ftp_ext_location')) {
                $table->dropColumn('ftp_ext_location');
            }
        });
    }
};
