<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('rvw_attachment_file_description', function (Blueprint $table) {
            Schema::table('rvw_attachment_file_description', function (Blueprint $table) {
                $table->char('afdec_submit_to_rvri', 1)
                      ->nullable()
                      ->default('n')
                      ->comment('yes-submit to rvri, no - not submit to rvri')
                      ->after('afdec_apply_stage_type');
            });
        });
        Schema::table('tbk_attachment_file_description', function (Blueprint $table) {
            Schema::table('tbk_attachment_file_description', function (Blueprint $table) {
                $table->char('afdec_submit_to_rvri', 1)
                      ->nullable()
                      ->default('n')
                      ->comment('yes-submit to rvri, no - not submit to rvri')
                      ->after('afdec_apply_stage_type');
            });
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('rvw_attachment_file_description', function (Blueprint $table) {
            Schema::dropColumn('afdec_submit_to_rvri');
        });

        Schema::table('tbk_attachment_file_description', function (Blueprint $table) {
            Schema::dropColumn('afdec_submit_to_rvri');
        });
    }
};
