<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('rvw_common_optional_select_colums', 'cosc_type')) {
            Schema::table('rvw_common_optional_select_colums', function (Blueprint $table) {
                $table->string('cosc_type')->after('cosc_colums')->comment('Name of the dataTable or page')->nullable();
            });
        }
        if (!Schema::hasColumn('tbk_common_optional_select_colums', 'cosc_type')) {
            Schema::table('tbk_common_optional_select_colums', function (Blueprint $table) {
                $table->string('cosc_type')->after('cosc_colums')->comment('Name of the dataTable or page')->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_common_optional_select_colums', 'cosc_type')) {
            Schema::table('rvw_common_optional_select_colums', function (Blueprint $table) {
                $table->dropColumn('cosc_type');
            });
        }
        if (Schema::hasColumn('tbk_common_optional_select_colums', 'cosc_type')) {
            Schema::table('tbk_common_optional_select_colums', function (Blueprint $table) {
                $table->dropColumn('cosc_type');
            });
        }
    }
};
