<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use App\Models\Generic_form_elements;
use Illuminate\Support\Facades\Log;
return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Get the database name safely (no risk of SQL injection)
$databaseName = DB::connection()->getDatabaseName();

$query = "SELECT TABLE_NAME 
          FROM INFORMATION_SCHEMA.TABLES 
          WHERE TABLE_SCHEMA = ? 
          AND TABLE_NAME LIKE 'rvw_article_gnf_form_data%'";

$results = DB::select($query, [$databaseName]);
if (!empty($results)) {
    foreach ($results as $table) {
        $tableName = $table->TABLE_NAME;
        Log::warning("Processing table: " . $tableName);
        
        if (Schema::hasTable($tableName)) {
            try {
                // Get records with mismatched identifiers

                /* $mismatchedRecords = DB::table('rvw_generic_form_elements')
                    ->select('gdata_id', 'emt_unique_identifier', 'gdata_unique_identifier')
                    ->join($tableName, 'gdata_atfemt_id', '=', 'emt_id')
                    ->whereColumn('gdata_unique_identifier', '!=', 'emt_unique_identifier')
                    ->get();
                     */

                    $mismatchedRecords = DB::table('rvw_generic_form_elements')
                    ->join($tableName, "$tableName.gdata_atfemt_id", '=', 'rvw_generic_form_elements.emt_id')
                    ->select(
                        "$tableName.gdata_id",
                        'rvw_generic_form_elements.emt_unique_identifier',
                        "$tableName.gdata_unique_identifier"
                    )
                    ->where(function ($query) use ($tableName) {
                        $query->whereColumn("$tableName.gdata_unique_identifier", '!=', 'rvw_generic_form_elements.emt_unique_identifier')
                            ->orWhere(function ($subQuery) use ($tableName) {
                                $subQuery->where(function ($q) use ($tableName) {
                                    $q->whereNull("$tableName.gdata_unique_identifier")
                                        ->whereNotNull('rvw_generic_form_elements.emt_unique_identifier');
                                })->orWhere(function ($q) use ($tableName) {
                                    $q->whereNotNull("$tableName.gdata_unique_identifier")
                                        ->whereNull('rvw_generic_form_elements.emt_unique_identifier');
                                });
                            });
                    })
                    ->get();
                if ($mismatchedRecords->isNotEmpty()) {
                    foreach ($mismatchedRecords as $record) {
                        Log::warning(sprintf(
                            "Mismatch found: %s^^%d^^%s", 
                            $record->emt_unique_identifier, 
                            $record->gdata_id, 
                            $record->gdata_unique_identifier
                        ));

                        // Use parameterized query for update
                        DB::table($tableName)
                            ->where('gdata_id', $record->gdata_id)
                            ->update(['gdata_unique_identifier' => $record->emt_unique_identifier]);

                        Log::warning(sprintf(
                            "Updated record %d in %s: set gdata_unique_identifier to %s",
                            $record->gdata_id,
                            $tableName,
                            $record->emt_unique_identifier
                        ));
                    }
                }
            } catch (\Exception $e) {
                Log::error("Error processing table {$tableName}: " . $e->getMessage());
                continue;
            }
        }
    }
}
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};