<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Get the database name safely (no risk of SQL injection)
        $databaseName = DB::connection()->getDatabaseName();

        $query = "SELECT TABLE_NAME 
                FROM INFORMATION_SCHEMA.TABLES 
                WHERE TABLE_SCHEMA = ? 
                AND TABLE_NAME LIKE 'rvw_article_gnf_form_data%'";

                $results = DB::select($query, [$databaseName]);
                if (!empty($results)) {
                    foreach ($results as $table) {
                        $tableName = $table->TABLE_NAME;
                        Log::warning("Processing table: " . $tableName);
                            
                        if (Schema::hasTable($tableName)) {
                            try {
                                // Get records with mismatched identifiers
                                $mismatchedRecords = DB::table('rvw_generic_form_elements')
                                    ->join($tableName, "$tableName.gdata_atfemt_id", '=', 'rvw_generic_form_elements.emt_id')
                                    ->select("$tableName.gdata_id",'rvw_generic_form_elements.emt_label',"$tableName.gdata_label")
                                    ->whereRaw('trim(rvw_generic_form_elements.emt_label) != trim('.$tableName.'.gdata_label)')
                                    ->get();

                                    if ($mismatchedRecords->isNotEmpty()) {
                                        foreach ($mismatchedRecords as $record) {
                                            Log::warning(sprintf(
                                                "Mismatch found: %s^^%d^^%s", 
                                                $record->emt_label, 
                                                $record->gdata_id, 
                                                $record->gdata_label
                                            ));

                                            // Use parameterized query for update
                                            DB::table($tableName)
                                                ->where('gdata_id', $record->gdata_id)
                                                ->update(['gdata_label' => $record->emt_label]);

                                            Log::warning(sprintf(
                                                "Updated record %d in %s: set gdata_label to %s",
                                                $record->gdata_id,
                                                $tableName,
                                                $record->emt_label
                                            ));
                                        }
                                    }
                                } catch (\Exception $e) {
                                    Log::error("Error processing table {$tableName}: " . $e->getMessage());
                                    continue;
                                }
                            }
                    }
                }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
