<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try {
                if (Schema::hasColumn('rvw_article_types', 'artp_prefix_article_no')) {
                    DB::statement("
                        ALTER TABLE `rvw_article_types` 
                        CHANGE `artp_prefix_article_no` `artp_prefix_article_no` 
                        VARCHAR(100) 
                        CHARACTER SET utf8mb4 
                        COLLATE utf8mb4_unicode_ci 
                        NOT NULL;
                    ");
                }
                if (Schema::hasColumn('tbk_article_types', 'artp_prefix_article_no')) {
                    DB::statement("
                        ALTER TABLE `tbk_article_types` 
                        CHANGE `artp_prefix_article_no` `artp_prefix_article_no` 
                        VARCHAR(100) 
                        CHARACTER SET utf8mb4 
                        COLLATE utf8mb4_unicode_ci 
                        NOT NULL;
                    ");
                }
            } catch (\Exception $e) {
                 DB::rollback();
            }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
         try {
            if (Schema::hasColumn('rvw_article_types', 'artp_prefix_article_no')) {
                DB::statement("
                    ALTER TABLE `rvw_article_types` 
                    CHANGE `artp_prefix_article_no` `artp_prefix_article_no` 
                    VARCHAR(20) 
                    CHARACTER SET utf8mb4 
                    COLLATE utf8mb4_unicode_ci 
                    NOT NULL;
                ");
            }

            if (Schema::hasColumn('tbk_article_types', 'artp_prefix_article_no')) {
                DB::statement("
                    ALTER TABLE `tbk_article_types` 
                    CHANGE `artp_prefix_article_no` `artp_prefix_article_no` 
                    VARCHAR(20) 
                    CHARACTER SET utf8mb4 
                    COLLATE utf8mb4_unicode_ci 
                    NOT NULL;
                ");
            }
        } catch (\Exception $e) {
             DB::rollback();
        }
    }
};
