<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class TbkJournalPermission extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbk_journal_permission', function (Blueprint $table) {
            $table->bigInteger('jpm_id');
            $table->bigInteger('jp_jpm_id');
            $table->jsonb('jp_add_notes')->nullable();
            $table->jsonb('jp_flag_articles')->nullable();
            $table->jsonb('jp_edit_articles')->nullable();
            $table->jsonb('jp_transfer_article')->nullable();
            $table->jsonb('jp_rescind_article')->nullable();
            $table->jsonb('jp_reset_article')->nullable();
            $table->jsonb('jp_view_auditrail')->nullable();
            $table->jsonb('jp_view_email_log')->nullable();
            $table->jsonb('jp_stage_manual_reminder')->nullable();
            $table->jsonb('jp_edit_reviewer_count')->nullable();
            $table->jsonb('jp_view_file_inventory')->nullable();
            $table->jsonb('jp_view_article_pdf')->nullable();
            $table->jsonb('jp_auto_assign_role')->nullable();
            $table->jsonb('jp_change_usr_assigmnts')->nullable();
            $table->jsonb('jp_move_article_from_payment')->nullable();
            $table->jsonb('jp_reinstantiate_payment')->nullable();
            $table->jsonb('jp_rate_reviewer')->nullable();
            $table->bigInteger('jp_posted_by')->nullable();
            $table->dateTime('jp_posted_date');
            $table->bigInteger('jp_proxy_id');
            $table->char('jp_operation',1);
            $table->bigIncrements('tbk_id');
            
        
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('tbk_journal_permission');
    }
}
