<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RvwJournalPermissionMasterTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('rvw_journal_permission_master', function (Blueprint $table) {
            $table->bigIncrements('jpm_id',20);
            $table->string('jpm_description',100)->comment('Description Master Table')->collation('utf8_unicode_ci');
            $table->bigInteger('jpm_posted_by');
            $table->dateTime('jpm_posted_date');
            $table->bigInteger('jpm_proxy_id');
            $table->char('jpm_operation',1)->collation('utf8_unicode_ci');
        });
        DB::unprepared('
        CREATE TRIGGER trg_journal_permission_master_after_insert AFTER INSERT ON `rvw_journal_permission_master` FOR EACH ROW
        BEGIN
        INSERT INTO tbk_journal_permission_master SELECT *,NULL tbk_id FROM rvw_journal_permission_master WHERE jpm_id= NEW.jpm_id;
        END
        ');
        DB::unprepared("
        CREATE TRIGGER trg_journal_permission_master_after_update AFTER UPDATE ON `rvw_journal_permission_master` FOR EACH ROW
        BEGIN
        IF NEW.jpm_operation != 'm'  THEN 
        INSERT INTO tbk_journal_permission_master SELECT *,NULL tbk_id FROM rvw_journal_permission_master WHERE jpm_id= OLD.jpm_id;
        END IF;
        END
        ");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('rvw_journal_permission_master');
    }
}
