<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RvwUserJournalDashboardSortKeys extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('rvw_user_journal_dashboard_sort_keys', function (Blueprint $table) {
            $table->bigIncrements('ujdtsk_id');
            $table->bigInteger('ujdtsk_usr_id');
            $table->bigInteger('ujdtsk_jnl_id');
            $table->text('ujdtsk_sort_keys')->collation('utf8_unicode_ci');
            $table->bigInteger('ujdtsk_posted_by');
            $table->dateTime('ujdtsk_posted_date');
            $table->bigInteger('ujdtsk_proxy_id');
            $table->char('ujdtsk_operation',1)->comment('u-update,i-insert')->collation('utf8_unicode_ci');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('rvw_user_journal_dashboard_sort_keys');
    }
}
