<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::beginTransaction();
        try
        {
            DB::statement("UPDATE `rvw_generic_discussion` SET `gdis_dsctp_id` = NULL WHERE gdis_dsctp_id = 0");
            DB::statement("ALTER TABLE `rvw_review_reject_reasons` ADD `rjct_inactive` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' AFTER `rjct_reinvite_flag`");
            DB::statement("ALTER TABLE `tbk_review_reject_reasons` ADD `rjct_inactive` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' AFTER `rjct_reinvite_flag`;");
            DB::statement("ALTER TABLE `rvw_review_reject_reasons` ADD `rjct_platform` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'j' COMMENT 'j = \'journals\', b =\'book\', c = \'conference\'' AFTER `rjct_reason`");
            DB::statement("ALTER TABLE `tbk_review_reject_reasons` ADD `rjct_platform` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'j' COMMENT 'j = \'journals\', b =\'book\', c = \'conference\'' AFTER `rjct_reason`;");
            DB::statement("UPDATE `rvw_review_reject_reasons` SET `rjct_platform`= 'b' WHERE `rjct_reason_reviewers` = 'c';");
            
            DB::statement("ALTER TABLE `rvw_article_types` ADD `artp_book_short_title` VARCHAR(150) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'short title of book' AFTER `artp_article_type`;");
            DB::statement("ALTER TABLE `tbk_article_types` ADD `artp_book_short_title` VARCHAR(150) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'short title of book' AFTER `artp_article_type`");
            DB::statement("ALTER TABLE `rvw_discussion_type` CHANGE `dsctp_role_id` `dsctp_role_id` JSON NULL DEFAULT NULL COMMENT 'pk of rvw_roles';");
            DB::statement("ALTER TABLE `tbk_discussion_type` CHANGE `dsctp_role_id` `dsctp_role_id` JSON NULL DEFAULT NULL;");
            DB::statement("ALTER TABLE `rvw_generic_discussion` ADD `gdis_enable_all_user` CHAR(5) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' AFTER `gdis_participants_by_usr_id`;");
            DB::statement("ALTER TABLE `tbk_generic_discussion` ADD `gdis_enable_all_user` CHAR(5) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' AFTER `gdis_participants_by_usr_id`;");
        
            DB::statement("ALTER TABLE rvw_users ADD usr_website VARCHAR(500) NULL DEFAULT NULL AFTER usr_email;");
            DB::statement("ALTER TABLE tbk_users ADD usr_website VARCHAR(500) NULL DEFAULT NULL AFTER usr_email;"); 
            DB::statement("ALTER TABLE rvw_author_affiliation ADD auaff_website VARCHAR(500) NULL AFTER auaff_postal_code;");
            DB::statement("ALTER TABLE tbk_author_affiliation ADD auaff_website VARCHAR(500) NULL AFTER auaff_postal_code;");
            DB::statement("ALTER TABLE rvw_user_affiliation ADD usaff_website VARCHAR(500) NULL AFTER usaff_postal_code;");
            DB::statement("ALTER TABLE tbk_user_affiliation ADD usaff_website VARCHAR(500) NULL AFTER usaff_postal_code;");
        }
        catch(\Exception $e)
        {
            throw new \Exception($e->getTraceAsString());
        }
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
        /*
        ALTER TABLE `rvw_review_reject_reasons` DROP `rjct_inactive`;
        ALTER TABLE `tbk_review_reject_reasons` DROP `rjct_inactive`;
        ALTER TABLE `rvw_review_reject_reasons` DROP `rjct_platform`;
        ALTER TABLE `tbk_review_reject_reasons` DROP `rjct_platform`;

        ALTER TABLE `rvw_article_types` DROP `artp_book_short_title`;
        ALTER TABLE `tbk_article_types` DROP `artp_book_short_title`;
        ALTER TABLE `rvw_generic_discussion` DROP `gdis_enable_all_user`;
        ALTER TABLE `tbk_generic_discussion` DROP `gdis_enable_all_user`;


        ALTER TABLE `rvw_users` DROP `usr_website`;
        ALTER TABLE `tbk_users` DROP `usr_website`;
        ALTER TABLE `rvw_author_affiliation` DROP `auaff_website`;
        ALTER TABLE `tbk_author_affiliation` DROP `auaff_website`;
        ALTER TABLE `rvw_user_affiliation` DROP `usaff_website`;
        ALTER TABLE `tbk_user_affiliation` DROP `usaff_website`;
        */
    }
};
