<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Http\Controllers\Controller;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::beginTransaction();
        try
        {
            $client_code=(new Controller())->get_client_details('clnt_client_code');
            if($client_code->clnt_client_code=='lepra'){
            DB::statement("ALTER TABLE `rvw_journal_settings` ADD `jset_blind_articles` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'permission to users to blind articles from user dashboard' AFTER `jset_generic_discussion`;");
            DB::statement("ALTER TABLE `tbk_journal_settings` ADD `jset_blind_articles` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'permission to users to blind articles from user dashboard' AFTER `jset_generic_discussion`;");
            DB::statement("ALTER TABLE `rvw_article_type_advance_options` ADD `atotp_blind_articles` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'permission to users to blind articles from user dashboard' AFTER `atotp_auto_assign_role`;");
            DB::statement("ALTER TABLE `tbk_article_type_advance_options` ADD `atotp_blind_articles` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'permission to users to blind articles from user dashboard' AFTER `atotp_auto_assign_role`;");
            DB::statement("CREATE TABLE `rvw_blind_article_to_users`(
                `bau_id` BIGINT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
                `bau_art_id` BIGINT(20) UNSIGNED NOT NULL,
                `bau_jnl_id` BIGINT(20) UNSIGNED NOT NULL,
                `bau_usr_ids` JSON NOT NULL,
                `bau_posted_date` DATETIME NOT NULL,
                `bau_posted_by` BIGINT(20) UNSIGNED NOT NULL,
                `bau_proxy_id` BIGINT(20) UNSIGNED NOT NULL,
                `bau_operation` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
                PRIMARY KEY (`bau_id`)
            ) ENGINE = InnoDB;
            ");
            DB::statement("CREATE TABLE `tbk_blind_article_to_users`(
                `bau_id` BIGINT(11) UNSIGNED NOT NULL,
                `bau_art_id` BIGINT(20) UNSIGNED NOT NULL,
                `bau_jnl_id` BIGINT(20) UNSIGNED NOT NULL,
                `bau_usr_ids` JSON NOT NULL,
                `bau_posted_date` DATETIME NOT NULL,
                `bau_posted_by` BIGINT(20) UNSIGNED NOT NULL,
                `bau_proxy_id` BIGINT(20) UNSIGNED NOT NULL,
                `bau_operation` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
                `tbk_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                PRIMARY KEY (`tbk_id`)
            ) ENGINE = InnoDB;
            ");
            DB::statement("CREATE TRIGGER `trg_blind_article_to_users_after_insert` AFTER INSERT ON `rvw_blind_article_to_users`
            FOR EACH ROW INSERT INTO tbk_blind_article_to_users SELECT *,NULL tbk_id FROM rvw_blind_article_to_users WHERE bau_id= NEW.bau_id;");
            DB::statement("CREATE TRIGGER `trg_blind_article_to_users_after_update` AFTER UPDATE ON `rvw_blind_article_to_users`
            FOR EACH ROW BEGIN 
                IF (NEW.bau_operation != 'm' AND NEW.bau_operation != 'e') 
                THEN 
                        INSERT INTO tbk_blind_article_to_users SELECT *,NULL tbk_id FROM rvw_blind_article_to_users WHERE bau_id= OLD.bau_id;
                END IF;
	    END ");
            }
        }
        catch(\Exception $e)
        {
            throw new \Exception($e->getTraceAsString());
        }

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('rvw_blind_article_to_users');
        Schema::dropIfExists('tbk_blind_article_to_users');
        /*
            ALTER TABLE `rvw_journal_settings` DROP `jset_blind_articles`;
            ALTER TABLE `tbk_journal_settings` DROP `jset_blind_articles`;
            ALTER TABLE `rvw_article_type_advance_options` DROP `atotp_blind_articles`;
            ALTER TABLE `tbk_article_type_advance_options` DROP `atotp_blind_articles`;
            DROP TABLE IF EXISTS `rvw_blind_article_to_users`;
            DROP TABLE IF EXISTS `tbk_blind_article_to_users`;
        */
    }
};
