<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::beginTransaction();
        try {
            DB::statement("ALTER TABLE `rvw_general_permissions` CHANGE `permission_roles` `permission_roles` JSON NULL DEFAULT NULL");
            DB::statement("ALTER TABLE `tbk_general_permissions` CHANGE `permission_roles` `permission_roles` JSON NULL DEFAULT NULL");
            DB::statement("ALTER TABLE `rvw_users` CHANGE `usr_roles` `usr_roles` JSON NULL DEFAULT NULL");
        } catch (\Exception $e) {
            DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::beginTransaction();
        try {
            DB::statement("ALTER TABLE `rvw_general_permissions` CHANGE `permission_roles` `permission_roles` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL");
            DB::statement("ALTER TABLE `tbk_general_permissions` CHANGE `permission_roles` `permission_roles` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL");
            DB::statement("ALTER TABLE `rvw_users` CHANGE `usr_roles` `usr_roles` TEXT NULL DEFAULT NULL");
        } catch (\Exception $e) {
            DB::rollback();
        }
    }
};
