<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try{
            DB::statement("ALTER TABLE `rvw_article_flow` ADD `aflw_author_suggested` CHAR(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'y= yes, n= no (default) [if yes then shortlisted author from suggested reviewer]' AFTER `aflw_decline_clk_count`");
            DB::statement("ALTER TABLE `tbk_article_flow` ADD `aflw_author_suggested` CHAR(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'y= yes, n= no (default) [if yes then shortlisted author from suggested reviewer]' AFTER `aflw_decline_clk_count`");

            DB::statement("ALTER TABLE `rvw_article_reviewers` ADD `sorw_author_suggested` CHAR(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'y= yes, n= no (default) [if yes then shortlisted author from suggested reviewer]' AFTER `sorw_usr_source`");
            DB::statement("ALTER TABLE `tbk_article_reviewers` ADD `sorw_author_suggested` CHAR(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'y= yes, n= no (default) [if yes then shortlisted author from suggested reviewer]' AFTER `sorw_usr_source`");

            DB::statement("ALTER TABLE `rvw_article_reviewers` ADD `sorw_shortlisted_reviewer` json DEFAULT NULL AFTER `sorw_usr_source`");
            DB::statement("ALTER TABLE `tbk_article_reviewers` ADD `sorw_shortlisted_reviewer` json DEFAULT NULL AFTER `sorw_usr_source`");
        }
        catch (\Exception $e) {
            DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
