<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try
        {
            DB::statement("CREATE TABLE IF NOT EXISTS `rvw_form_edithistory` (
                `feh_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                `feh_art_id` bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_articles',
                `feh_aflw_id` bigint(20) UNSIGNED DEFAULT NULL COMMENT 'pk of rvw_article_flow',
                `feh_gncf_id` bigint(20) UNSIGNED DEFAULT NULL COMMENT 'pk of rvw_article_gnf_form_data',
                `feh_posted_by` bigint(20) UNSIGNED NOT NULL,
                `feh_proxy_id` bigint(20) UNSIGNED DEFAULT NULL,
                `feh_posted_date` datetime NOT NULL,
                `feh_merge_date` datetime DEFAULT NULL,
                `feh_operation` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
               PRIMARY KEY (`feh_id`)
              ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

           /* DB::statement("CREATE TABLE IF NOT EXISTS `tbk_form_edithistory` (
                `feh_id` bigint(20) UNSIGNED NOT NULL,
                `feh_art_id` bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_articles',
                `feh_aflw_id` bigint(20) UNSIGNED DEFAULT NULL COMMENT 'pk of rvw_article_flow',
                `feh_gncf_id` bigint(20) UNSIGNED DEFAULT NULL COMMENT 'pk of rvw_article_gnf_form_data',
                `feh_posted_by` bigint(20) UNSIGNED NOT NULL,
                `feh_proxy_id` bigint(20) UNSIGNED DEFAULT NULL,
                `feh_posted_date` datetime NOT NULL,
                `feh_merge_date` datetime DEFAULT NULL,
                `feh_operation` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
                `tbk_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
               PRIMARY KEY (`tbk_id`)
              ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");*/

            DB::statement("ALTER TABLE `rvw_form_edithistory` ADD INDEX(`feh_art_id`);");
            DB::statement("ALTER TABLE `rvw_form_edithistory` ADD INDEX(`feh_aflw_id`);");
            DB::statement("ALTER TABLE `rvw_form_edithistory` ADD FOREIGN KEY (`feh_art_id`) REFERENCES `rvw_articles`(`art_id`) ON DELETE CASCADE ON UPDATE CASCADE;");
            DB::statement("ALTER TABLE `rvw_form_edithistory` ADD FOREIGN KEY (`feh_aflw_id`) REFERENCES `rvw_article_flow`(`aflw_id`) ON DELETE CASCADE ON UPDATE CASCADE;");
            
            // DB::unprepared("Drop trigger if exists trg_form_edithistory_after_insert; CREATE TRIGGER trg_form_edithistory_after_insert  AFTER INSERT ON rvw_form_edithistory FOR EACH ROW INSERT INTO tbk_form_edithistory SELECT *,NULL tbk_id FROM rvw_form_edithistory WHERE feh_id= NEW.feh_id;");
            
            // DB::unprepared("Drop trigger if exists trg_form_edithistory_after_update; CREATE TRIGGER trg_form_edithistory_after_update  AFTER UPDATE ON rvw_form_edithistory FOR EACH ROW INSERT INTO tbk_form_edithistory SELECT *,NULL tbk_id FROM rvw_form_edithistory WHERE feh_id= OLD.feh_id;");

            DB::statement("ALTER TABLE `rvw_journal_permission` ADD `jp_edit_article_forms` JSON NULL DEFAULT NULL COMMENT 'edit article forms' AFTER `jp_edit_articles`;");
            DB::statement("ALTER TABLE `tbk_journal_permission` ADD `jp_edit_article_forms` JSON NULL DEFAULT NULL COMMENT 'edit article forms' AFTER `jp_edit_articles`;");
        }
        catch(\Exception $e)
        {
            DB::rollback();
            //print_r($e);
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::drop("rvw_form_edithistory");
        Schema::drop("tbk_form_edithistory");
        DB::statement("ALTER TABLE rvw_journal_permission DROP jp_edit_article_forms;");
        DB::statement("ALTER TABLE tbk_journal_permission DROP jp_edit_article_forms;");
    }
};
