<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $tables = DB::select("SHOW TABLES LIKE '%article_gnf_form_data%' ");

        foreach ($tables as $table) {
            foreach($table as $key => $tb_name){
                Schema::table($tb_name, function (Blueprint $table) {
                    $table->integer('gdata_dynamic_id')->default(0)->after('gdata_gfg_id');
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        $tables = DB::select("SHOW TABLES LIKE '%article_gnf_form_data%' ");

        foreach ($tables as $table) {
            foreach($table as $key => $tb_name){
                Schema::table($tb_name, function (Blueprint $table) {
                    $table->dropColumn('gdata_dynamic_id');
                });
            }
        }
    }
};
