<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('rvw_temp_classification_import')) {
            Schema::create('rvw_temp_classification_import', function (Blueprint $table) {
                $table->id('tci_id');
                $table->bigInteger('tci_cls_id', false, true)->comment('pk of rvw_classifications');
                $table->bigInteger('tci_term_id', false, true)->comment('pk of rvw_terms');
                $table->bigInteger('tci_primary_id', false, true);
                $table->bigInteger('tci_level', false, true);
                $table->bigInteger('tci_parent_id', false, true);
                $table->bigInteger('tci_posted_by', false, true);
                $table->timestamp('tci_posted_date');
                $table->bigInteger('tci_proxy_id', false, true);
                $table->char('tci_operation', 1)->default('n');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasTable('rvw_temp_classification_import')) {
            Schema::dropIfExists('rvw_temp_classification_import');
        }
    }
};
