<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('rvw_article_type_advance_options', 'atotp_title_length')) {
            Schema::table('rvw_article_type_advance_options', function (Blueprint $table) {
                $table->integer('atotp_title_length')->default(250)->comment('length of title')->after('atotp_paper_length');
            });
        }
        if (!Schema::hasColumn('tbk_article_type_advance_options', 'atotp_title_length')) {
            Schema::table('tbk_article_type_advance_options', function (Blueprint $table) {
                $table->integer('atotp_title_length')->default(250)->comment('length of title')->after('atotp_paper_length');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_article_type_advance_options', 'atotp_title_length')) {
            Schema::table('rvw_article_type_advance_options', function (Blueprint $table) {
                $table->dropColumn('atotp_title_length');
            });
        }
        if (Schema::hasColumn('tbk_article_type_advance_options', 'atotp_title_length')) {
            Schema::table('tbk_article_type_advance_options', function (Blueprint $table) {
                $table->dropColumn('atotp_title_length');
            });
        }
    }
};
