<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {

        Schema::table('rvw_journal_settings', function (Blueprint $table) {
            $table->char('jset_review_method', 1)->comment('o=open,s=single_blind,d=double_blind, c=custom_blind')->change();
            $table->json('jset_custom_blind_params')->nullable()->after('jset_review_method');
        });

        Schema::table('tbk_journal_settings', function (Blueprint $table) {
            $table->char('jset_review_method', 1)->comment('o=open,s=single_blind,d=double_blind, c=custom_blind')->change();
            $table->json('jset_custom_blind_params')->nullable()->after('jset_review_method');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('rvw_journal_settings', function (Blueprint $table) {
            $table->char('jset_review_method', 1)->comment('o=open,s=single_blind,d=double_blind')->change();
            $table->dropColumn('jset_custom_blind_params');
        });

        Schema::table('tbk_journal_settings', function (Blueprint $table) {
            $table->char('jset_review_method', 1)->comment('o=open,s=single_blind,d=double_blind')->change();
            $table->dropColumn('jset_custom_blind_params');
        });
    }
};
