<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('rvw_journal_settings', 'jset_jats_export'))
        {
            Schema::table('rvw_journal_settings', function (Blueprint $table) {
                $table->json('jset_jats_export')->after('jset_prevent_edit')->nullable();        
            });
        }
        if (!Schema::hasColumn('tbk_journal_settings', 'jset_jats_export'))
        {
            Schema::table('tbk_journal_settings', function (Blueprint $table) {
                $table->json('jset_jats_export')->after('jset_prevent_edit')->nullable();              
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_journal_settings', 'jset_jats_export'))
        {
            Schema::table('rvw_journal_settings', function (Blueprint $table) {
                $table->dropColumn('jset_jats_export');        
            });
        }
        if (Schema::hasColumn('tbk_journal_settings', 'jset_jats_export'))
        {
            Schema::table('tbk_journal_settings', function (Blueprint $table) {
                $table->dropColumn('jset_jats_export');              
            });
        }
    }
};
