<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
              $table_exist = Schema::connection('mysql_common')->hasTable('rvw_note_category');
        if (!$table_exist) {
            Schema::connection('mysql_common')->create('rvw_note_category', function (Blueprint $table) {
            $table->id('note_cat_id');
            $table->string('note_cat_title',250);
            $table->string('note_cat_description',250);
            $table->unsignedBigInteger('note_cat_posted_by');
            $table->dateTime('note_cat_posted_date');
            $table->unsignedBigInteger('note_cat_proxy_id')->nullable();
            $table->char('note_cat_operation', 1);
        });
    }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rvw_note_category');
    }
};
