<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $table_exist = Schema::connection('mysql_common')->hasTable('rvw_note_label');
        if (!$table_exist) {
            Schema::connection('mysql_common')->create('rvw_note_label', function (Blueprint $table) {
            $table->id('notelbl_id');
            $table->integer('notelbl_note_id', false, true)->comment('pk of rvw_release_notes');
            $table->string('notelbl_title',1000);
            $table->string('notelbl_color',1000);
            $table->unsignedBigInteger('notelbl_posted_by');
            $table->dateTime('notelbl_posted_date');
            $table->unsignedBigInteger('notelbl_proxy_id')->nullable();
            $table->char('notelbl_operation', 1);

        });
       }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rvw_note_label');
    }
};
