<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try {
            Schema::table('rvw_journal_permission', function (Blueprint $table) {
                $table->json('jp_request_rescind')->nullable()->after('jp_prevent_edit');
            });
            Schema::table('tbk_journal_permission', function (Blueprint $table) {
                $table->json('jp_request_rescind')->nullable()->after('jp_prevent_edit');
            });
        } catch (\Exception $e) {
            throw new \Exception($e->getTraceAsString());
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('rvw_journal_permission', function (Blueprint $table) {
            $table->dropColumn('jp_request_rescind');
        });
    }
};
