<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('rvw_article_transfer_suggestion', 'ats_reason'))
        {
            Schema::table('rvw_article_transfer_suggestion', function (Blueprint $table) {
                $table->mediumText('ats_reason')->after('ats_author_action')->nullable()->comment('Reason for author transfer condition based');
            });
        }
        if (!Schema::hasColumn('tbk_article_transfer_suggestion', 'artp_status'))
        {
            Schema::table('tbk_article_transfer_suggestion', function (Blueprint $table) {
                $table->mediumText('ats_reason')->after('ats_author_action')->nullable()->comment('Reason for author transfer condition based');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
        if (Schema::hasColumn('rvw_journal_settings', 'jset_batch_reviews'))
        {
            Schema::table('rvw_journal_settings', function (Blueprint $table) {
                $table->dropColumn('jset_batch_reviews');
            });
        }
        if (Schema::hasColumn('tbk_journal_settings', 'jset_batch_reviews'))
        {
            Schema::table('tbk_journal_settings', function (Blueprint $table) {
                $table->dropColumn('jset_batch_reviews');
            });
        }
    }
};
