<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rvw_article_author_history', function (Blueprint $table) {
            $table->id('aah_id');
            $table->bigInteger('aah_art_id', false, true);
            $table->json('aah_auth_ids');
            $table->integer('aah_posted_by');
            $table->date('aah_posted_date');
            $table->integer('aah_proxy_id')->default(0);
            $table->enum('aah_operation', ['i', 'd', 'u']);
            $table->foreign('aah_art_id')->references('art_id')->on('rvw_articles')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rvw_article_author_history');
    }
};
