<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * this update sql is to update the 'tour_steps_cnt' with the count of steps saved in tour_details tbl
     */
    public function up(): void
    {
        try{
            DB::statement('ALTER TABLE rvw_tour_details ADD INDEX(tourdt_tour_id)');
            DB::statement("UPDATE rvw_tours t JOIN( SELECT tourdt_tour_id, COUNT(tourdt_id) AS tour_steps_cnt FROM rvw_tour_details GROUP BY tourdt_tour_id ) td ON t.tour_id = td.tourdt_tour_id SET t.tour_steps_cnt = td.tour_steps_cnt");
        }
        catch (\Exception $e) {
            DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
