<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try
        {
            if (!Schema::hasColumn('rvw_article_flag', 'aflg_aflw_id')) {
            DB::statement("ALTER TABLE `rvw_article_flag` ADD `aflg_aflw_id` BIGINT NULL DEFAULT NULL COMMENT ' pk of rvw_article_flow table' AFTER `aflg_emt_id`");
            }
            if (!Schema::hasColumn('tbk_article_flag', 'aflg_aflw_id')) {
                DB::statement("ALTER TABLE `tbk_article_flag` ADD `aflg_aflw_id` BIGINT NULL DEFAULT NULL COMMENT ' pk of rvw_article_flow table' AFTER `aflg_emt_id`");
                }
        }
        catch(\Exception $e)
        {
            Log::warning("alterarticleflagtable feild failed");
            Log::warning($e->getMessage());
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_article_flag', 'aflg_aflw_id')) {
            DB::statement("ALTER TABLE `rvw_article_flag` DROP `aflg_aflw_id`");
        }
        if (Schema::hasColumn('tbk_article_flag', 'aflg_aflw_id')) {
            DB::statement("ALTER TABLE `tbk_article_flag` DROP `aflg_aflw_id`");
        }
    }
};
