<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try {
            // Static table names to be updated directly
            $staticTables = [
                'rvw_article_gnf_form_data',
                'tbk_article_gnf_form_data',
                'rvw_article_gnf_form_data_temp',
                'tbk_article_gnf_form_data_temp'
            ];

            // Adding the gdata_aflg_flag_id column to static tables
            foreach ($staticTables as $table) {
                if (Schema::hasTable($table)) {
                    if (!Schema::hasColumn($table, 'gdata_flag_id')) {
                        Schema::table($table, function (Blueprint $table) {
                            $table->dropColumn('gdata_flag');
                            $table->bigInteger('gdata_flag_id')->nullable()->default(null)
                                  ->comment('pk of rvw_flags,Element flag id')
                                  ->after('gdata_dynamic_status');
                        });
                    }
                    if (!Schema::hasColumn($table, 'gdata_flag_deletestatus')) {
                        Schema::table($table, function (Blueprint $table) {
                            $table->char('gdata_flag_deletestatus',1)->nullable()->default('n')
                            ->comment('y=yes,n=no')
                            ->after('gdata_dynamic_status');

                        });
                    }
                }
            }

            // Get all jnl_journal_code values from the rvw_journals table
            $journals = DB::table('rvw_journals')->select('jnl_journal_code')->get();

            // Process each journal code to create dynamic table names: rvw_ and tbk_
            $tableNames = $journals->flatMap(function ($journal) {
                return [
                    'rvw_article_gnf_form_data_' . $journal->jnl_journal_code,
                    'tbk_article_gnf_form_data_' . $journal->jnl_journal_code
                ];
            });

            // Adding the gdata_aflg_flag_id column to dynamic tables based on journal codes
            foreach ($tableNames as $tableName) {
                if (Schema::hasTable($tableName)) {
                    if (!Schema::hasColumn($tableName, 'gdata_flag_id')) {
                        Schema::table($tableName, function (Blueprint $table) {
                            $table->dropColumn('gdata_flag');
                            $table->bigInteger('gdata_flag_id')->nullable()->default(null)
                                  ->comment('pk of rvw_flags,Element flag id')
                                  ->after('gdata_dynamic_status');
                        });
                    }
                    if (!Schema::hasColumn($tableName, 'gdata_flag_deletestatus')) {
                        Schema::table($tableName, function (Blueprint $table) {
                            $table->char('gdata_flag_deletestatus',1)->nullable()->default('n')
                            ->comment('y=yes,n=no')
                            ->after('gdata_dynamic_status');
                        });
                    }
                }
            }
        } catch (\Exception $e) {
            Log::error('Migration error: ' . $e->getMessage());
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        try {
            // Static table names to drop the gdata_flag column
            $staticTables = [
                'rvw_article_gnf_form_data',
                'tbk_article_gnf_form_data',
                'rvw_article_gnf_form_data_temp',
                'tbk_article_gnf_form_data_temp'
            ];

            // Dropping the gdata_flag_id column from static tables
            foreach ($staticTables as $table) {
                if (Schema::hasTable($table) && Schema::hasColumn($table, 'gdata_flag_id')) {
                    Schema::table($table, function (Blueprint $table) {
                        $table->dropColumn('gdata_flag_id');
                    });
                }
                if (Schema::hasTable($table) && Schema::hasColumn($table, 'gdata_flag_deletestatus')) {
                    Schema::table($table, function (Blueprint $table) {
                        $table->dropColumn('gdata_flag_deletestatus');
                    });
                }
            }

            // Get all jnl_journal_code values from the rvw_journals table
            $journals = DB::table('rvw_journals')->select('jnl_journal_code')->get();

            // Process each journal code to create dynamic table names: rvw_ and tbk_
            $tableNames = $journals->flatMap(function ($journal) {
                return [
                    'rvw_article_gnf_form_data_' . $journal->jnl_journal_code,
                    'tbk_article_gnf_form_data_' . $journal->jnl_journal_code
                ];
            });

            // Dropping the gdata_flag_id column from dynamic tables
            foreach ($tableNames as $tableName) {
                if (Schema::hasTable($tableName) && Schema::hasColumn($tableName, 'gdata_flag_id')) {
                    Schema::table($tableName, function (Blueprint $table) {
                        $table->dropColumn('gdata_flag_id');
                    });
                }
                if (Schema::hasTable($tableName) && Schema::hasColumn($tableName, 'gdata_flag_deletestatus')) {
                    Schema::table($tableName, function (Blueprint $table) {
                        $table->dropColumn('gdata_flag_deletestatus');
                    });
                }
            }
        } catch (\Exception $e) {
            Log::error('Migration rollback error: ' . $e->getMessage());
        }
    }
};
