<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $table_exist = Schema::connection('mysql_common')->hasTable('rvw_client_functionalities');
        if (!$table_exist) {
            Schema::connection('mysql_common')->create('rvw_client_functionalities', function (Blueprint $table) {
                $table->id('cfty_id');
                $table->string('cfty_functionality', 50);
                $table->char('cfty_status', 1);
                $table->unsignedBigInteger('cfty_posted_by');
                $table->dateTime('cfty_posted_date');
                $table->unsignedBigInteger('cfty_proxy_id')->nullable();
                $table->char('cfty_operation', 1);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
